#include <fstream>

#include <util/folder/dirut.h>
#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/http_server.h>

#include "service.h"

namespace NWebmaster {

static volatile bool gRunning = true;

static void OnTerminate(int = 0) {
    gRunning = false;
}

int Main() {
    InitNetworkSubSystem();

    // Manage signals
    signal(SIGPIPE, SIG_IGN);
    signal(SIGINT, OnTerminate);
    signal(SIGTERM, OnTerminate);

    TBlackBoxProxyService bbService;

    THttpServer httpServer(25051, 8, &bbService);

    // Wait for signals
    do {
        sleep(1);
    } while (gRunning);

    LOG_INFO("Exiting");

    return 0;
}

} //namespace NWebmaster

int main(int argc, const char** argv) {
    using namespace NWebmaster;

    int res = 1;

    TArgs::Init(argc, argv);
    TArgs::ParseOpts();

    LOG_INFO("Started");
    try {
        return NWebmaster::Main();
    } catch (std::exception& e) {
        LOG_CRIT("%s", e.what());
    }
    LOG_INFO("Finished");

    return res;
}
