#include <wmconsole/version3/wmcutil/log.h>

#include "auth.h"
#include "service.h"

namespace NWebmaster {

TBlackBoxProxyService::TBlackBoxProxyService() {
    AddAction("/session.xml", this, &TBlackBoxProxyService::MethodSession);
}

bool TBlackBoxProxyService::MethodSession(THttpServer::TRequest &request) {
    LOG_INFO("requested %s - [%s]", request.Method.data(), request.GetRemoteAddr().data());

    TString host, ip, sessionId;

    if (!request.GetFilledParameter("session_id", sessionId)) {
        return true;
    }

    if (!request.GetFilledParameter("ip", ip)) {
        return true;
    }

    if (!request.GetFilledParameter("host", host)) {
        return true;
    }

    try {
        TBlackBox bb;
        TString uid;
        bb.GetUserId(sessionId, host, ip, uid);
        request.Output() << "HTTP/1.1 200 Ok\r\n\r\n" << uid;
        LOG_INFO("request processed");
    } catch(const yexception &e) {
        LOG_ERROR("unable to complete answer: %s", e.what());
        request.Die(500, e.what());
    }

    return true;
}

} //namespace NWebmaster
