import urltree_pb2
import datetime
from yt.wrapper.client import Yt
import yt
import os

check_hosts = [
    "https://lenta.ru",
    #"https://www.afisha.ru",
    "http://www.bloknotov.ru",
    "https://webmaster.yandex.ru",
]

def get_timestamp(table):
    timestamp = int(table.split("-")[-1])
    timestamp = datetime.datetime.fromtimestamp(timestamp)
    return timestamp

def extract_msg(msg, acceptance):
    obj = { }

    if acceptance:
        check_shard_id = urltree_pb2.RU_ACCEPTANCE
    else:
        check_shard_id = urltree_pb2.RU

    for node in msg.nodes:
        if node.node_id == 1 and node.shard_id == check_shard_id:
            obj['num_of_docs'] = node.num_of_docs
            obj['num_of_docs_on_search'] = node.num_of_docs_on_search
            obj['num_of_new_search_docs'] = node.num_of_new_search_docs
            obj['num_of_gone_search_docs'] = node.num_of_gone_search_docs
    return obj

def print_state(client, table, acceptance):
    state = {}
    transmitted_table = table
    for host in check_hosts:
        state[host] = {}
        for line in client.read_table("%s[\"%s\"]" % (transmitted_table, host), raw=False, format=yt.wrapper.JsonFormat()):
            obj = urltree_pb2.HostInfo()
            obj.ParseFromString(line["value"])
            #print host
            obj = extract_msg(obj, acceptance);
            for key in obj:
                #print " -", key, obj[key]
                state[host][key] = obj[key]
    return state

def get_table_name(table):
    return table.split("/")[-1]

if __name__ == "__main__":
    client = Yt(proxy='banach.yt.yandex.net', token=os.getenv("YT_TOKEN"))

    root = "//home/webmaster/prod/sitetree"

    root_suspicious = root + "/suspicious"
    root_transmitted = root + "/ready"

    transmitted = []
    suspicious = []

    for table in sorted(client.search(root, node_type="table", attributes=["row_count"])):
        if table.startswith(root_suspicious):
            suspicious.append(table)
        elif table.startswith(root_transmitted):
            transmitted.append(table)

    transmitted_table = sorted(transmitted)[-1]

    for acceptance in [False, True]:
        print("acceptance:", acceptance)
        tran_state = print_state(client, transmitted_table, acceptance)

        susp_state = []
        for table in suspicious:
            row_count = table.attributes['row_count']
            print(get_table_name(transmitted_table), "date:", get_timestamp(transmitted_table), "->")
            print(get_table_name(table), "date:", get_timestamp(table), "row_count:", row_count)
            susp_state.append(print_state(client, table, acceptance))

        for host in tran_state:
            print(host)
            for ss in susp_state:
                for key in tran_state[host]:
                    tran_val = tran_state[host][key]
                    susp_val = ss[host][key]
                    print(" -", key, tran_val, susp_val)
        print()
