#!/usr/bin/env python

import datetime
import re
import os

from yt.wrapper import YtClient

client = YtClient(proxy='banach.yt.yandex.net', token=os.getenv("YT_TOKEN"))

root = "//home/webmaster/prod/export/delurl"

day_groups = { }

now = datetime.datetime.now()

for table in sorted(client.search(root, node_type="table", attributes=["row_count"])):
    if int(table.attributes["row_count"]) == 0:
        print "drop empty table", table
        client.remove(table)
        continue

    match = re.search("\\.(\\d+)$", table)

    if match:
        timestamp = match.groups()[0]
        timestamp = datetime.datetime.strptime(timestamp, "%Y%m%d%H%M%S")
        group = timestamp.date()
        age_days = (now - timestamp).days
        if age_days <= 7:
            continue

        try:
            day_groups[group].append(table)
        except:
            day_groups[group] = []
            day_groups[group].append(table)
    else:
        raise BaseException("unable to parse table name " + table)

for group in sorted(day_groups):
    input_tables = sorted(day_groups[group])
    output_table = input_tables[-1]
    if len(input_tables) > 1:
        print group, "merging %d tables into %s" % (len(input_tables), output_table)
        with client.Transaction():
            client.run_merge(input_tables, output_table)
            for table in input_tables:
                if table != output_table:
                    client.remove(table)
                    print "drop table", table
