#include <mapreduce/yt/interface/client.h>
#include <library/cpp/protobuf/json/proto2json.h>
#include <yweb/protos/links.pb.h>
#include <yweb/robot/preparat/io/io.h>

#include <wmconsole/version3/protos/links.pb.h>
#include <wmconsole/version3/wmcutil/url.h>

int main(int argc, const char **argv) {
    using namespace NWebmaster;

    if (argc < 3) {
        Cerr << "usage: " << argv[0] << "//preparat/shard http://target/link" << Endl;
        return 1;
    }

    const TString shard = argv[1];
    const TString key = argv[2];

    NYT::IClientPtr client = NYT::CreateClient("banach.yt.yandex.net");
    NYT::TRichYPath path(shard);
    path.AddRange(NYT::TReadRange().Exact(NYT::TReadLimit().Key(NYT::TKey(key))));

    auto reader = client->CreateTableReader<NYT::TYaMRRow>(path);

    for (; reader->IsValid(); reader->Next()) {
        const NYT::TYaMRRow row = reader->GetRow();
        const TString dstUrl = TString{row.Key};

        TString dstHost, dstPath;
        if (!NUtils::SplitUrl(TString{row.Key}, dstHost, dstPath)) {
            Cerr << "Link " << dstUrl << " unable to target source url" << Endl;
            continue;
        }

        Cout << "Key# " << dstUrl << Endl;

        try {
            TInputLinksData links;
            Y_VERIFY(links.ParseFromArray(row.Value.data(), row.Value.length()), "Can't parse TInputLinksData");

            NPreparat::TTextualReader reader(dstUrl, &links.GetText());

            for (size_t i = 0; i < links.LinkSize(); ++i) {
                proto::links::RawLinkInfo msg;

                const TInputLinksData::TLink& link = links.GetLink(i);

                if (!link.HasUrlKey()) {
                    Cerr << "Link " << dstUrl << " doesn't have url key" << Endl;
                    continue;
                }

                const TString text = TString{reader.GetText(link.GetTextKey())};
                const TString source = TString{reader.GetUrl(link.GetUrlKey())};

                TString srcHost, srcPath;
                if (!NUtils::SplitUrl(source, srcHost, srcPath)) {
                    Cerr << "Link " << dstUrl << " unable to split source url" << Endl;
                    continue;
                }

                //TString srcOwner, error;
                //if (!Owners.GetOwner(source, srcOwner, error)) {
                    //Cerr << "Link " << dstUrl << " enable to get owner" << Endl;
                    //continue;
                //}

                //bool internal = (srcOwner == dstOwner);

                //int tci = 0;
                //if (HostsTci.has(srcHost)) {
                    //tci = HostsTci[srcHost]; //use external tci source in WMC-3347
                //}

                //msg.set_timestamp(SnapshotTs);
                //msg.set_internal(internal);
                msg.set_link_date(link.GetLinkDate());

                msg.set_source_host(srcHost);
                msg.set_source_path(srcPath);
                //msg.set_source_tci(tci);
                msg.set_source_last_access(link.GetSourceLastAccess());

                //msg.set_target_host(dstHost);
                //msg.set_target_path(dstPath);
                msg.set_target_http_code(link.GetDstHttpCode());
                msg.set_target_last_access(link.GetDstLastAccess());

                if (!text.empty()) {
                    msg.set_text(text);
                }

                TString stream;
                Y_PROTOBUF_SUPPRESS_NODISCARD msg.SerializeToString(&stream);

                NProtobufJson::TProto2JsonConfig config;
                config.SetFormatOutput(true);
                Cout << NProtobufJson::Proto2Json(msg, config) << Endl;
            }
        } catch(yexception &e) {
            Cerr << e.what() << Endl;
        }
    }
}
