#include <util/datetime/base.h>

#include "config.h"

namespace NWebmaster {

void TConfig::Load() {
    TConfigBase::Load();

    Assign(MONITOR_PERFORMANCE_SUFFIX, "monitor.performance.suffix");

    Assign(MR_SERVER_HOST_LOGS, "mapreduce.server.host.logs");

    Assign(TABLE_SOURCE_FRONT_LOGS_DAILY_ROOT,      "table.source.front_logs.daily.root");
    Assign(TABLE_SOURCE_FRONT_LOGS_STREAM5M_ROOT,   "table.source.front_logs.stream5m.root");
    Assign(TABLE_SPAM_DEFENCE_ROOT,                 "table.spam_defence.root");

    TABLE_SPAM_DEFENCE_ROOT_1D          = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT, "1d");
    TABLE_SPAM_DEFENCE_ROOT_5M          = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT, "stream", "5m");

    TABLE_SPAM_DEFENCE_1D_PARSED        = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_1D, "parsed-logs");
    TABLE_SPAM_DEFENCE_1D_NOT_PARSED    = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_1D, "not-parsed-logs");
    TABLE_SPAM_DEFENCE_1D_FOREIGN       = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_1D, "foreign-reqs");
    TABLE_SPAM_DEFENCE_1D_REPORT_UID    = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_1D, "report-uid");
    TABLE_SPAM_DEFENCE_1D_REPORT_OWNER  = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_1D, "report-owner");

    TABLE_SPAM_DEFENCE_5M_PARSED        = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_5M, "parsed-logs");
    TABLE_SPAM_DEFENCE_5M_NOT_PARSED    = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_5M, "not-parsed-logs");
    TABLE_SPAM_DEFENCE_5M_FOREIGN       = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_5M, "foreign-reqs");
    TABLE_SPAM_DEFENCE_5M_REPORT_UID    = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_5M, "report-uid");
    TABLE_SPAM_DEFENCE_5M_REPORT_OWNER  = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT_5M, "report-owner");

    TABLE_SPAM_DEFENCE_BAN_SUGGEST_ROOT     = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_ROOT, "suggest/stream/5m");
    TABLE_SPAM_DEFENCE_BAN_SUGGEST_UID      = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_BAN_SUGGEST_ROOT, "suggest-uid");
    TABLE_SPAM_DEFENCE_BAN_SUGGEST_OWNER    = NYTUtils::JoinPath(TABLE_SPAM_DEFENCE_BAN_SUGGEST_ROOT, "suggest-owner");
}

} //namespace NWebmaster
