#pragma once

#include <util/generic/singleton.h>
#include <wmconsole/version3/wmcutil/config_base.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TConfig : TConfigBase {
    void Load() override;

    static TConfig& Instance() {
        return *Singleton<TConfig>();
    }

public:
    TString MR_SERVER_HOST_LOGS;

    TString TABLE_SOURCE_FRONT_LOGS_DAILY_ROOT;
    TString TABLE_SOURCE_FRONT_LOGS_STREAM5M_ROOT;

    TString TABLE_SPAM_DEFENCE_ROOT;
    TString TABLE_SPAM_DEFENCE_ROOT_1D;
    TString TABLE_SPAM_DEFENCE_1D_PARSED;
    TString TABLE_SPAM_DEFENCE_1D_NOT_PARSED;
    TString TABLE_SPAM_DEFENCE_1D_FOREIGN;
    TString TABLE_SPAM_DEFENCE_1D_REPORT_UID;
    TString TABLE_SPAM_DEFENCE_1D_REPORT_OWNER;

    TString TABLE_SPAM_DEFENCE_ROOT_5M;
    TString TABLE_SPAM_DEFENCE_5M_PARSED;
    TString TABLE_SPAM_DEFENCE_5M_NOT_PARSED;
    TString TABLE_SPAM_DEFENCE_5M_FOREIGN;
    TString TABLE_SPAM_DEFENCE_5M_REPORT_UID;
    TString TABLE_SPAM_DEFENCE_5M_REPORT_OWNER;

    TString TABLE_SPAM_DEFENCE_BAN_SUGGEST_ROOT;
    TString TABLE_SPAM_DEFENCE_BAN_SUGGEST_UID;
    TString TABLE_SPAM_DEFENCE_BAN_SUGGEST_OWNER;

    TString MONITOR_PERFORMANCE_SUFFIX;
    TString PERIODIC_LOG_HANDLER;
};

} //namespace NWebmaster
