#pragma once

#include <util/memory/blob.h>

#include <library/cpp/archive/yarchive.h>

inline void LoadDataFromArchive(const TString &name, TBlob &blob) {
    static const unsigned char ARCHIVE_DATA[] = {
       #include "archive.inc"
    };

    TArchiveReader archive(TBlob::NoCopy(ARCHIVE_DATA, Y_ARRAY_SIZE(ARCHIVE_DATA)));
    for (size_t i = 0; i < archive.Count(); i++) {
        const TString key = archive.KeyByIndex(i);
        if (key == name) {
            blob = archive.ObjectBlobByKey(key);
            return;
        }
    }
}
