#pragma once

#include <util/generic/singleton.h>

#include <catboost/libs/model/model.h>

#include "dataset.h"

struct TClfPredictor {
    TClfPredictor();
    double Predict(const TString &hostname) const;
    TVector<double> Predict(const TVector<TString> &hostnames) const;
    int GetClass(double probability) const;

    static TClfPredictor& Instance() {
        return *Singleton<TClfPredictor>();
    }

public:
    TFullModel CatboostFormulaEvaluator;
    NCB::NModelEvaluation::TModelEvaluatorPtr ProbabilityEvaluator;
    TClfDataset ClfDataset;
};
