#include <util/generic/vector.h>
#include <util/generic/map.h>
#include <util/generic/set.h>
#include <util/stream/file.h>
#include <util/stream/str.h>
#include <util/stream/output.h>

#include <wmconsole/version3/junk/spam_hosts_ml/dataset/dataset.h>

int main(int argc, const char **argv) {
    Y_UNUSED(argc);
    Y_UNUSED(argv);

    //const TString hostname = "lenta.ru";
    TVector<float> featuresList;

    TClfDataset clfDataset;

    TUnbufferedFileInput input("data.shuf");
    for(TString line; input.ReadLine(line);) {
        TString hostname;
        int target = 0;
        TStringInput stream(line);
        stream >> target >> hostname;

        clfDataset.GetFeaturesWithTarget(hostname, target, featuresList);

        for (size_t i = 0; i < featuresList.size(); i++) {
            Cout << static_cast<double>(featuresList[i]);
            if (i != featuresList.size() - 1) {
                Cout << "\t";
            }
        }
        Cout << Endl;
    }
}
