#include "ru_yandex_webmaster3_core_util_ArcUtils.h"

#include <util/generic/string.h>
#include <kernel/tarc/iface/arcface.h>
#include <util/stream/output.h>
#include <util/stream/str.h>
#include <util/memory/blob.h>
#include <kernel/tarc/iface/tarcio.h>
#include <kernel/tarc/markup_zones/arcreader.h>
#include <kernel/tarc/markup_zones/view_sent.h>

jint JNI_OnLoad(JavaVM* jvm, void*) {
    JNIEnv* env;
    if (jvm->GetEnv((void**) &env, JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }
    return JNI_VERSION_1_6;
}

JNIEXPORT jstring JNICALL Java_ru_yandex_webmaster3_core_util_ArcUtils_extractDocText(JNIEnv *env, jclass, jbyteArray arcData) {
    jbyte* arcDataBytes = env->GetByteArrayElements(arcData, nullptr);
    jsize arcDataSize = env->GetArrayLength(arcData);

    const TArchiveHeader* archive = reinterpret_cast<const TArchiveHeader*>(arcDataBytes);
    TString docTextStr{""};
    if ((jsize)archive->DocLen == arcDataSize) {
        TStringStream output;
        TBlob docText = GetArchiveDocText(archive);
        TTArcViewSentReader sentReader(/*SentAttrs=*/false, /*DecodeSentAttrs=*/false);
        PrintDocText(output, docText, /*MarkupZone=*/false, /*WeightZone=*/false, /*NeedExtended=*/true, /*TitleAsAttr=*/false, sentReader, /*MarkupZoneAttrs=*/false);
        docTextStr = std::move(output.Str());
    }

    env->ReleaseByteArrayElements(arcData, arcDataBytes, JNI_ABORT);

    return env->NewStringUTF(docTextStr.c_str());
}
