#include "ru_yandex_webmaster3_core_util_UrlUtils.h"
#include <library/cpp/uri/uri.h>

JNIEXPORT jstring JNICALL Java_ru_yandex_webmaster3_core_util_UrlUtils_canonizeUrlForRobot
(JNIEnv * env, jclass, jstring url) {
    const char* urlStr = env->GetStringUTFChars(url, nullptr);
    if (nullptr == urlStr) {
        return nullptr;
    }

    NUri::TUri parser;
    auto code = parser.ParseAbs(urlStr, NUri::TUri::FeaturesRecommended);
    if (code != NUri::TUri::ParsedOK) {
        env->ReleaseStringUTFChars(url, urlStr);
        return nullptr;
    }

    TString canonicalUrl = parser.PrintS(::NUri::TUri::FlagNoFrag);

    env->ReleaseStringUTFChars(url, urlStr);
    return env->NewStringUTF(canonicalUrl.c_str());
}
