#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/env/yt.h>

namespace NWebmaster {

struct TCommonYTConfig {
    static const TCommonYTConfig &CInstance() {
        return *Singleton<TCommonYTConfig>();
    }

    TCommonYTConfig() {
        ENV                                 = TCustomYTEnvironment::CInstance().ENV;

        TABLE_ROOT                          = TCustomYTEnvironment::CInstance().TABLE_ENV_ROOT;
        TABLE_TEMP_ROOT                     = TCustomYTEnvironment::CInstance().TABLE_ENV_TEMP_ROOT;
        TABLE_INQUOTA_TEMP_ROOT             = TCustomYTEnvironment::CInstance().TABLE_ENV_INQUOTA_TEMP_ROOT;

        TABLE_EXPORT_ROOT                   = NYTUtils::JoinPath(TABLE_ROOT, "export");
        TABLE_USER_ROOT                     = NYTUtils::JoinPath(TABLE_ROOT, "user");
        TABLE_STAGE_ROOT                    = NYTUtils::JoinPath(TABLE_ROOT, "stage");
        TABLE_STAGE_EXPORT_ROOT             = NYTUtils::JoinPath(TABLE_STAGE_ROOT, "export");
        TABLE_STAGE_USER_ROOT               = NYTUtils::JoinPath(TABLE_STAGE_ROOT, "user");

        FILE_SOURCE_MODELS_ROOT             = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "models");
        FILE_L3_MODEL_DSSM                  = NYTUtils::JoinPath(FILE_SOURCE_MODELS_ROOT, "l3_model.dssm");
        FILE_XF_ONE_SE_MODEL_DSSM           = NYTUtils::JoinPath(FILE_SOURCE_MODELS_ROOT, "DssmBoostingXfOneSE.dssm");

        MR_SERVER_HOST_JUPITER              = "arnold.yt.yandex.net";
        MR_SERVER_HOST_KWYT                 = "arnold.yt.yandex.net";
        MR_SERVER_HOST_MODELS_HOST2VEC      = "hahn.yt.yandex.net";
        MR_SERVER_HOST_RADAR                = "hahn.yt.yandex.net";

        FILE_MODEL_HOST2VEC_SG              = NYTUtils::JoinPath(FILE_SOURCE_MODELS_ROOT, "host2vec_sg");
        FILE_MODEL_HOST2VEC_SPYLOG          = NYTUtils::JoinPath(FILE_SOURCE_MODELS_ROOT, "host2vec");
        FILE_MODEL_HOST2VEC_SPYLOG_FILTERED = NYTUtils::JoinPath(FILE_SOURCE_MODELS_ROOT, "host2vec-filtered");
        FILE_MODEL_HOST2VEC_SERP            = NYTUtils::JoinPath(FILE_SOURCE_MODELS_ROOT, "host2vec_serp");

        TABLE_SOURCE_JUPITER_ACCEPTANCE_ROOT    = "//home/jupiter/acceptance";
        TABLE_SOURCE_JUPITER_EXPORT_ROOT        = "//home/jupiter/export";

        //TABLE_SOURCE_PORNO_HOSTS            = "//home/antispam/export/antiporno/porno_hosts";
        TABLE_SOURCE_PORNO_HOSTS            = "//home/antispam/nasty/linear/porno_database";

        TABLE_SOURCE_WEBMASTER_HOSTS        = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "webmaster-hosts");
        TABLE_SOURCE_USER_URLS              = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "user-urls/user-urls");
        TABLE_SOURCE_REL_CANONICAL          = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "user-urls/rel-canonical");
        TABLE_SOURCE_FROM_SITEMAP           = NYTUtils::JoinPath(TABLE_EXPORT_ROOT, "user-urls/from-sitemap");

        MONITOR_PERFORMANCE_SUFFIX          = ENV == "prod" ? "production" : "testing";
    }

    TString GetAcceptedPath(TString path) const {
        SubstGlobal(path, TABLE_STAGE_ROOT, TABLE_ROOT);
        return path;
    }

    TString GetStagePath(TString path) const {
        SubstGlobal(path, TABLE_ROOT, TABLE_STAGE_ROOT);
        return path;
    }

public:
    TString ENV;

    TString TABLE_ROOT;

    TString TABLE_EXPORT_ROOT;
    TString TABLE_TEMP_ROOT;
    TString TABLE_INQUOTA_TEMP_ROOT;
    TString TABLE_USER_ROOT;
    TString TABLE_STAGE_ROOT;
    TString TABLE_STAGE_EXPORT_ROOT;
    TString TABLE_STAGE_USER_ROOT;

    TString TABLE_SOURCE_PORNO_HOSTS;
    TString TABLE_SOURCE_WEBMASTER_HOSTS;
    TString TABLE_SOURCE_USER_URLS;
    TString TABLE_SOURCE_REL_CANONICAL;
    TString TABLE_SOURCE_FROM_SITEMAP;

    TString TABLE_SOURCE_JUPITER_ACCEPTANCE_ROOT;
    TString TABLE_SOURCE_JUPITER_EXPORT_ROOT;

    TString FILE_SOURCE_MODELS_ROOT;
    TString FILE_L3_MODEL_DSSM;
    TString FILE_XF_ONE_SE_MODEL_DSSM;

    TString MONITOR_PERFORMANCE_SUFFIX;

    TString MR_SERVER_HOST_JUPITER;
    TString MR_SERVER_HOST_KWYT;
    TString MR_SERVER_HOST_MODELS_HOST2VEC;
    TString MR_SERVER_HOST_RADAR;

    TString FILE_MODEL_HOST2VEC_SG;
    TString FILE_MODEL_HOST2VEC_SPYLOG;
    TString FILE_MODEL_HOST2VEC_SPYLOG_FILTERED;
    TString FILE_MODEL_HOST2VEC_SERP;
};

} //namespace NWebmaster
