#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

struct TBaseYTEnvironment {
    TBaseYTEnvironment() = default;
    TBaseYTEnvironment(const TString &env) {
        Init(env);
    }

    void Init(const TString &env) {
        ENV                         = env;

        TABLE_WMC_ROOT              = "//home/webmaster";
        TABLE_WMC_TEMP_ROOT         = "//tmp/webmaster";

        TABLE_ENV_ROOT              = NYTUtils::JoinPath(TABLE_WMC_ROOT, env);
        TABLE_ENV_TEMP_ROOT         = NYTUtils::JoinPath(TABLE_WMC_TEMP_ROOT, env);
        TABLE_ENV_INQUOTA_TEMP_ROOT = NYTUtils::JoinPath(TABLE_ENV_ROOT, "tmp");
    }

    virtual ~TBaseYTEnvironment() = default;

public:
    TString ENV;
    TString TABLE_WMC_ROOT;
    TString TABLE_WMC_TEMP_ROOT;
    TString TABLE_ENV_ROOT;
    TString TABLE_ENV_TEMP_ROOT;
    TString TABLE_ENV_INQUOTA_TEMP_ROOT;
};


struct TProdYTEnvironment : public TBaseYTEnvironment {
    TProdYTEnvironment()
        : TBaseYTEnvironment("prod")
    {
    }
};

struct TTestYTEnvironment : public TBaseYTEnvironment {
    TTestYTEnvironment()
        : TBaseYTEnvironment("test")
    {
    }
};

struct TCustomYTEnvironment : public TBaseYTEnvironment {
    static TCustomYTEnvironment &Instance() {
        return *Singleton<TCustomYTEnvironment>();
    }

    static const TCustomYTEnvironment &CInstance() {
        return *Singleton<TCustomYTEnvironment>();
    }
};

} //namespace NWebmaster
