#pragma once

#include <algorithm>

namespace NWebmaster {

inline size_t RoundToRadix(float x, size_t radix) {
    size_t res = x;
    res = (res / radix) * radix;
    return res + radix / 2 >= x ? res : res + radix;
}

inline size_t RoundIKS(float x) {
    if (x <= 5000) {
        return RoundToRadix(x, 10);
    } else if (x <= 10000) {
        return RoundToRadix(x, 50);
    } else if (x <= 50000) {
        return RoundToRadix(x, 100);
    } else if (x <= 100000) {
        return RoundToRadix(x, 500);
    } else if (x <= 500000) {
        return RoundToRadix(x, 1000);
    } else {
        return std::min<size_t>(950000, RoundToRadix(x, 5000));
    }
}

} //namespace NWebmaster
