#pragma once

#include <mapreduce/yt/interface/client.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

namespace NWebmaster {

bool GetJupiterAcceptanceState(NYT::IClientBasePtr client, TString &state, TString &error);
bool GetJupiterProductionState(NYT::IClientBasePtr client, TString &state, TString &error);
bool GetJupiterDessertAcceptanceState(NYT::IClientBasePtr client, TString &state, TString &error);
bool IsSpreadUrlBannedBySourceId(const NYT::TNode &row);
time_t GetJupiterTsTZFromPath(const TString &path);
time_t GetTsTZFromJupiterState(const TString &state);
TString GetJupiterStateFromTsTZ(time_t timestamp);
TString GetJupiterAcceptanceHostTable(NYT::IClientBasePtr client);
TString GetJupiterAcceptanceInPrevProdTable(NYT::IClientBasePtr client);
TString GetJupiterAcceptanceInProdHostTable(NYT::IClientBasePtr client);
TString GetJupiterAcceptanceInProdTable(NYT::IClientBasePtr client);
TString GetJupiterAcceptanceTable(NYT::IClientBasePtr client);
TString GetJupiterContentAttrsInProdTable(NYT::IClientBasePtr client);
TString GetJupiterContentAttrsTable(NYT::IClientBasePtr client);
TString GetJupiterMirrorsTrieFile(NYT::IClientBasePtr client);
TString GetJupiterMirrorsTrieInProdFile(NYT::IClientBasePtr client);
TString GetJupiterMirrorsInProdTable(NYT::IClientBasePtr client);
TString GetJupiterSamovarPreparatInProdTable(NYT::IClientBasePtr client);
TString GetUserfeatLongUserBrowseLemurDataInProdTable(NYT::IClientBasePtr client);
TString GetUserfeatUserCountersLemurDataInProdTable(NYT::IClientBasePtr client);
TString GetJupiterSpreadExportPrefix();
TString GetJupiterStateFromPath(const TString &path);
void LoadHostSpreadTables(NYT::IClientBasePtr client, time_t jupiterTimestampTZ, TDeque<NYTUtils::TTableInfo> &spreadTables);
void LoadSpreadTables(NYT::IClientBasePtr client, time_t jupiterTimestampTZ, TDeque<NYTUtils::TTableInfo> &spreadTables);
TString GetJupiterCurrentLinksTable(NYT::IClientBasePtr client);
TString GetJupiterPreviousLinksTable(NYT::IClientBasePtr client);
bool IsImagePathExtension(const TString &path);
TString GetPathExtension(const TString &path);

} //namespace NWebmaster
