#include <util/generic/hash.h>
#include <util/string/cast.h>

#include <library/cpp/http/fetch/exthttpcodes.h>

#include <robot/jupiter/protos/acceptance.pb.h>

#include "search_url_status.h"

namespace NWebmaster {
namespace NSearchUrlStatus {

ESearchUrlStatus RawToView(ui64 jupiterStatus, bool searchable) {
    if (searchable) {
        return INDEXED_SEARCHABLE;
    }
    switch (jupiterStatus) {
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_HOST_ERROR:
            return HOST_ERROR;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_REDIRECT:
            return REDIRECT_NOTSEARCHABLE;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_HTTP_ERROR:
            return HTTP_ERROR;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_NOT_CANONICAL:
            return NOT_CANONICAL;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_NOT_MAIN_MIRROR:
            return NOT_MAIN_MIRROR;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_PARSER_ERROR:
            return PARSER_ERROR;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_ROBOTS_HOST_ERROR:
            return ROBOTS_HOST_ERROR;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_ROBOTS_URL_ERROR:
            return ROBOTS_URL_ERROR;
            //noinspection fallthrough
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_SEMIDUP:
            return SEMIDUP;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_INDEXED:
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_SPAM:
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_SR:
            return SR;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_CLEAN_PARAMS:
            return CLEAN_PARAMS;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_NO_INDEX:
            return NO_INDEX;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_BAD_MIME_TYPE:
            return BAD_MIME_TYPE;
        case NJupiter::EAcceptanceUrlForWebMasterSimpleStatus::AUFWSS_OTHER:
            return OTHER;
        default:
            return NOTHING_FOUND;
    }
}

TString ViewToStr(ESearchUrlStatus urlStatus) {
    static const THashMap<ESearchUrlStatus, TString> STATUS_MAP {
        { INDEXED_SEARCHABLE, "SEARCHABLE" },
        { SEMIDUP, "DUPLICATE" },
        { SR, "BAD_QUALITY" },
        { PARSER_ERROR, "PARSE_ERROR" },
        { ROBOTS_URL_ERROR, "ROBOTS_TXT_ERROR" },
        { NOTHING_FOUND, "UNKNOWN_URL" },
        { NO_INDEX, "META_NO_INDEX" },
    };

    if (STATUS_MAP.contains(urlStatus)) {
        return STATUS_MAP.at(urlStatus);
    }

    return ToString(urlStatus);
}

TString HttpCodeToViewStr(int httpCode) {
    if (httpCode == 0 || httpCode == EXT_HTTP_CLEANPARAM) {
        return "";
    }
    if ((httpCode >= 1000 && httpCode < 2000) || (httpCode >= 3000)) {
        return "";
    } else if (httpCode >= 2000 && httpCode < 3000) {
        return "200";
    }
    return ToString(httpCode);
}

} //namespace NSearchUrlStatus
} //namespace NWebmaster
