#pragma once

#include <util/generic/string.h>
#include <util/system/types.h>

namespace NWebmaster {
namespace NSearchUrlStatus {

enum ESearchUrlStatus {
    INDEXED_SEARCHABLE,
    NOT_MAIN_MIRROR,
    ROBOTS_HOST_ERROR,
    INDEXED_NOTSEARCHABLE,
    REDIRECT_SEARCHABLE,
    REDIRECT_NOTSEARCHABLE,
    SEMIDUP,
    NOT_CANONICAL,
    SR,
    HTTP_ERROR,
    PARSER_ERROR,
    HOST_ERROR,
    ROBOTS_URL_ERROR,
    OTHER,
    NOTHING_FOUND,
    CLEAN_PARAMS,
    NO_INDEX,
    BAD_MIME_TYPE
};

// !!!:      
//  ru.yandex.webmaster3.core.sitestructure.SearchUrlStatusUtil.raw2View
ESearchUrlStatus RawToView(ui64 jupiterStatus, bool searchable);

TString ViewToStr(ESearchUrlStatus);
TString HttpCodeToViewStr(int httpCode);

} //namespace NSearchUrlStatus
} //namespace NWebmaster
