#pragma once

#include <yweb/robot/ukrop/algo/sourceconfig/sourceconfig.h>
#include <yweb/robot/ukrop/common/exception.h>

#include <wmconsole/version3/wmcutil/builtin_fs.h>

namespace NWebmaster {
    // see WMCSUPPORT-4321
    static const TString SAMOVAR_FRESH_SOURCE = "samovar_fresh";

struct TSourceConfigHolder {
public:
    const NUkrop::TSourceConfig SourceConfig;
private:
    Y_DECLARE_SINGLETON_FRIEND();

    TSourceConfigHolder()
        : SourceConfig(TStringStream(NUtil::ReadBuiltin("builtin://yweb/robot/ukrop/conf/conf-production/sourceconfig.pb.txt")))
    {
    }

public:
    static TSourceConfigHolder* Instance() {
        return Singleton<TSourceConfigHolder>();
    }

    static bool IsAllowedZoraSource(const TString& sourceName, const ui32 sourceId = 255) {
        if (sourceName == SAMOVAR_FRESH_SOURCE) {
            return true;
        }
        const auto& sourceConfig = Instance()->SourceConfig;
        return sourceConfig.IsAllowedZoraSource(sourceId, sourceName);
    }
};

} //namespace NWebmaster
