#include <util/memory/blob.h>
#include <util/stream/file.h>

#include <wmconsole/version3/wmcutil/archive.h>

#include "sanctions.h"

namespace NWebmaster {

static const unsigned char SANCTIONS_DATA[] = {
    #include "sanctions.inc"
};

TSanctions::TSanctions() {
    const int ARCHIVE_INDEX_SANCTIONS = 0;
    NJson::TJsonValue sanctionsJson;
    NUtils::ReadJsonFromArchive(SANCTIONS_DATA, sanctionsJson, ARCHIVE_INDEX_SANCTIONS);
    for (const auto &obj: sanctionsJson.GetMap()) {
        if (obj.second.Has("threat")) {
            SanctionToThreat[obj.first] = obj.second["threat"].GetString();
        }
    }
}

bool TSanctions::GetThreatName(const TString &sanction, TString &threat) const {
    const TString req = TString{TStringBuf(sanction).Before(':')};
    if (SanctionToThreat.contains(req)) {
        threat = SanctionToThreat.at(req);
        return true;
    }
    return false;
}

} //namespace NWebmaster
