
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `SearchEngines_Patterns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SearchEngines_Patterns` (
  `Id` bigint(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'In order of priority',
  `SearchEngineId` bigint(10) unsigned NOT NULL,
  `Pattern` varchar(1000) NOT NULL COMMENT '1st subpattern is search phrase',
  `QuickPattern` varchar(1000) NOT NULL COMMENT 'for check with strcasecmp',
  `Charset` enum('Auto','KOI8R') NOT NULL DEFAULT 'Auto',
  PRIMARY KEY (`Id`),
  KEY `FK_SearchEngineId` (`SearchEngineId`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `SearchEngines_Patterns` WRITE;
/*!40000 ALTER TABLE `SearchEngines_Patterns` DISABLE KEYS */;
INSERT INTO `SearchEngines_Patterns` VALUES (1,2,'^(?:https?://)?(?:(?:www|direct|direkt|yabs)\\.)?yandex\\.[\\w\\.]{2,}/(?:yand|family|school|site)?search.*?[\\?;&]','yandex','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (3,3,'^(?:https?://)?(?:www\\.|images\\.)?google\\.[\\w\\.]{2,}/?(?:/(?:(?:search|ie|url|aclk|#)(?:/?$|.*[\\?;&#](?:\\w+_)?(?:q\\=([^#&]*))?))|webhp|$)','google','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (4,10,'^(?:https?://)?(?:[^?/]*?\\.)?rambler\\.ru/.*?[\\?&](?:oe=koi8r|set=top100).*?&(?:words|query)=([^&#]*)','rambler','KOI8R');
INSERT INTO `SearchEngines_Patterns` VALUES (5,9,'^(?:https?://)?(?:[^?/]*?\\.)?search\\.yahoo\\.[\\w\\.]{2,}/(?:yhs/)?(?:search)?(:?(.*?[\\?&]p=([^&#]*)|$))','yahoo','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (6,8,'^(?:https?://)?(?:[^?/]*?\\.)?(search\\.)?msn\\.com/(results\\.aspx|searchresults|search|weathersearch)(?:\\?(?:.*?q=([^&#]*)))?','msn','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (8,6,'^(?:https?://)?(?:[^?/]*?\\.)?(?:go|search)\\.mail\\.ru/(search|redir|wlsearch|q)\\?(?:.*?q=([^&#]*))?','mail.ru','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (90,6,'^(?:https?://)?go\\.mail\\.ru/?$','mail.ru','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (9,5,'^(?:https?://)?(?:[^?/]*?\\.)?search\\.live\\.com/results\\.aspx(?:\\?(?:.*?q=([^&#]*)))?','search.live','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (13,11,'^(?:https?://)?(?:video\\.)?google\\.[\\w\\.]{2,}/videosearch.*?[\\?;&]q\\=([^#&]*)','google','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (14,12,'^(?:https?://)?(?:images\\.|www\\.)?google?\\.[\\w\\.]{2,}/images.*?[\\?;&]q\\=([^#&]*)','google','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (15,13,'^(?:https?://)?(?:pda|m)\\.ya(?:ndex)?\\.[\\w\\.]{2,}/(?:(?:m|tel|touch|pad)search|search/(?:pad|smart|touch)?)(?:\\.xml)?(:?.*?[\\?;&]query\\=([^#&]*))?','yandex','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (22,20,'^(?:https?://)?(?:www\\.)?gogo\\.ru/go\\?q=([^#&]*)','gogo.ru','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (26,12,'^(?:https?://)?(?:images\\.|www\\.)?google?\\.[\\w\\.]{2,}/img(?:res|landing|hp).*?(?:[\\?;&]q\\=([^#&]*))?','google','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (27,28,'^(?:https?://)?(?:www\\.)?google\\.[\\w\\.]{2,}/search.*?[\\?;&]q\\=([^#&]*).*?&tbm=blg','&tbm=blg','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (29,10,'^(?:https?://)?(?:[^?/]*?\\.)?rambler\\.ru/.*?[\\?&](?:words|query)=([^&#]*)','rambler','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (36,43,'^(?:https?://)?(?:[^?/]*?\\.)?rambler\\.ru/video\\?.*?query=([^&#]*)','rambler','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (37,44,'^(?:https?://)?(?:[^?/]*?\\.)?rambler\\.ru/(?:pic_cache|pictures\\?.*?query=([^&#]*))','rambler','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (39,46,'^(?:https?://)?go\\.mail\\.ru/(?:(?:details|frame)\\.html|search_images)\\?.*?q=([^&#]*)','mail.ru','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (40,47,'^(?:https?://)?search\\.live\\.com/video/results\\.aspx\\?.*?q=([^&#]*)','search.live','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (41,48,'^(?:https?://)?search\\.live\\.com/images/results\\.aspx\\?.*?q=([^&#]*)','search.live','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (42,51,'^(?:https?://)?shopping\\.yahoo\\.[\\w\\.]{2,}/.*?\\Wp=([^&#]*)','yahoo','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (43,50,'^(?:https?://)?(?:images\\.)?search\\.yahoo\\.[\\w\\.]{2,}/(?:search/)?images.*?\\Wp=([^&#]*)','yahoo','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (44,49,'^(?:https?://)?(?:video\\.)?search\\.yahoo\\.[\\w\\.]{2,}/(?:search/)?video.*?\\Wp=([^&#]*)','yahoo','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (45,54,'^(?:https?://)?(?:[^?/]*?\\.)?search\\.yahoo\\.com/yhs/search\\?.*?fr=altavista.*?&q=([^&#]*)','altavista','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (46,53,'^(?:https?://)?(?:www\\.)?altavista\\.com/image/.*?[\\?;&]q=([^&#]*)','altavista','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (48,63,'^(?:https?://)?(?:www\\.)?gogo\\.ru/images.*?[\\?;&]q=([^&#]*)','gogo.ru','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (49,62,'^(?:https?://)?(?:www\\.)?gogo\\.ru/video.*?[\\?;&]q=([^&#]*)','gogo.ru','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (54,56,'^(?:https?://)?(?:search\\.)?msn\\.com/images/results\\.aspx.*?[\\?;&]q=([^&#]*)','search.msn','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (55,55,'^(?:https?://)?(?:search\\.)?msn\\.com/video/results\\.aspx.*?[\\?;&]q=([^&#]*)','search.msn','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (60,69,'^(?:https?://)?(?:search\\.)?icq\\.com/search/(?:img_results|selected_img)\\.php.*?[\\?;&]q=([^&#]*)','search.icq','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (61,68,'^(?:https?://)?(?:www\\.|pda\\.|wap\\.|m\\.)?google\\.[\\w\\.]{2,}/(?:m|xhtml|pda|cse/mobile_search_results\\.html|.*?[\\?;&]output=xhtml).*?[\\?;&]q\\=([^#&]*)','google','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (62,67,'^(?:https?://)?(?:www\\.)?google\\.[\\w\\.]{2,}/(?:custom|cse)(?:.*?[\\?;&]q\\=([^#&]*))?','google','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (63,71,'^(?:https?://)?(?:search\\.)?icq\\.com/search/.*?results\\.php.*?[\\?;&]q=([^&#]*)','search.icq','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (64,72,'^(?:https?://)?(?:[^?/]*?\\.)?search\\.live\\.com/spresults\\.aspx(?:\\?(?:.*?q=([^&#]*)))?','search.live','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (65,73,'^(?:https?://)?(?:[^?/]*?\\.)?search\\.msn\\.com/spresults\\.aspx(?:\\?(?:.*?q=([^&#]*)))?','search.msn','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (66,13,'^(?:https?://)?(?:www\\.)?yandex\\.[\\w\\.]{2,}/(?:m|tel|touch|pad)search.*?[\\?;&](?:text|query|q)\\=([^#&]*)','yandex','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (69,77,'^(?:https?://)?(?:search\\.)?ukr\\.net/google/search\\.php.*?[\\?;&]q\\=([^#&]*)','ukr.net','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (70,78,'^(?:https?://)?(?:search\\.)?ukr\\.net/yandex/search\\.php.*?[\\?;&]search_query\\=([^#&]*)','ukr.net','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (71,83,'^(?:https?://)?(?:news\\.|www\\.)?google\\.[\\w\\.]{2,}/news.*?[\\?;&]q\\=([^#&]*)','google','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (72,87,'^(?:https?://)?(?:www\\.)?bing\\.com/videos/search.*?[\\?;&](?:q|MT)=([^&#]*)','bing','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (73,86,'^(?:https?://)?(?:www\\.)?bing\\.com/images/search.*?[\\?;&](?:q|MT)=([^&#]*)','bing','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (74,85,'^(?:https?://)?(?:www\\.)?bing\\.com/(?:fbf/)?(?:search|spresults).*?[\\?;&](?:q|MT)=([^&#]*)','bing','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (75,88,'^(?:https?://)?(?:www\\.)?google\\.[\\w\\.]{2,}/gwt/.*?[\\?;&](?:\\w+_)?q\\=([^#&]*)','/gwt/','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (76,91,'^(?:https?://)?(?:[^?/]*?\\.)?ask\\.com/(?:pictures|fr|mywebsearch/AJimage\\.jhtml|search/AJimage\\.jhtml)=([^&#]*)','ask.com','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (77,90,'^(?:https?://)?(?:[^?/]*?\\.)?ask\\.com/(?:web|bar|mywebsearch/AJmain\\.jhtml|search/GGmain\\.jhtml|search/GGweb\\.jhtml|search/GGdirs\\.jhtml).*?(?:q|searchfor)=([^&#]*)','ask.com','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (78,92,'^(?:https?://)?(?:[^?/]*?\\.)?ask\\.com/(?:video|youtube).*?q=([^&#]*)','ask.com','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (80,11,'^(?:https?://)?(?:www\\.)?google\\.[\\w\\.]{2,}/search.*?[\\?;&]q\\=([^#&]*).*?&tbm=vid','&tbm=vid','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (81,12,'^(?:https?://)?(?:images\\.|www\\.)?google?\\.[\\w\\.]{2,}/imgres\\?.*?[&\\?]prev=[^&#]*%[0-9A-Z]{2}q%3D([^#&]*?)(?:%2[63]|[&#]|$)','/imgres','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (82,44,'^(?:https?://)?images\\.rambler\\.ru/srch\\?query=([^&#]*)','rambler','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (83,111,'^(?:https?://)?(?:www\\.)?blekko\\.com/ws/(?:\\?q=)?([^\\?&#]+)','blekko','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (84,112,'^(?:https?://)?(?:www\\.)?topsy\\.com/s(?:\\?q=|/)([^\\?&#]+)','topsy','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (85,119,'^(?:https?://)?(?:[^?/]*?\\.)?(?:go|search)\\.mail\\.ru/msearch(?:\\?(?:.*?q=([^&#]*)))?','mail.ru/msearch','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (86,120,'^(?:https?://)?(?:[^?/]*?\\.)?(?:go|search)\\.mail\\.ru/mimages(?:\\?(?:.*?q=([^&#]*)))?','mail.ru/mimages','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (87,12,'^(?:https?://)?(?:images\\.|www\\.)?google\\.[\\w.]{2,}/search.*[?;&]q=([^#&]*).*[?;&]tbm=isch','tbm=isch','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (88,12,'^(?:https?://)?(?:images\\.|www\\.)?google\\.[\\w.]{2,}/search.*[?;&]tbm=isch.*[?;&]q=([^#&]*)','tbm=isch','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (89,179,'^(?:https?://)?(?:[\\w\\.]+\\.)?m\\.yahoo\\.[\\w.]{2,}/.*[?;&]p=([^#&]*)','m.yahoo.com','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (92,182,'^(?:https?://)?(?:(?:www)\\.)?beta\\.yandex\\.[\\w\\.]{2,}/[^&\\?;#]*search.*?[\\?;&]text\\=([^#&]*)','beta.yandex.','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (93,75,'^(?:https?://)?(?:(?:www)\\.)?yandex\\.[\\w\\.]{2,}/video/[^&\\?;]*search.*?[\\?;&]text\\=([^#&]*)','yandex.','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (94,179,'^(?:https?://)?(?:[^?/]*?\\.)?search\\.yahoo\\.[\\w\\.]{2,}/mobile/s.*?[\\?&]p=([^&#]*)','yahoo','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (95,1,'^(?:https?://)?yandex\\.(?:[\\w\\.]{2,}/(?:images|gorsel))/(?:touch/|smart/|pad/)?(?:search\\?.*?text\\=([^#&]*))?','yandex','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (96,185,'^(?:https?://)?(?:www\\.)?sputnik\\.ru/search\\?q\\=([^#&]*)','sputnik','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (97,189,'^(?:https?://)?search\\.ukr\\.net/[\\?;&]q\\=([^#&]*)','ukr.net','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (98,2,'^(?:https?://)?(?:www\\.)?yandex\\.[\\w\\.]{2,}/clck/jsredir.*?[\\?;&](?:text|query|q)=([^#&]*)','yandex','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (99,2,'^(?:https?://)?clck\\.yandex\\.[\\w\\.]{2,}/jsredir.*?[\\?;&](?:text|query|q)=([^#&]*)','yandex','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (100,2,'^(?:https?://)?yandex\\.[\\w.]{2,}/$','yandex','Auto');
INSERT INTO `SearchEngines_Patterns` VALUES (101,3,'^(?:https?://)?google\\.[\\w.]{2,}/$','google','Auto');
/*!40000 ALTER TABLE `SearchEngines_Patterns` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

