#!/usr/bin/env python

import sqlparse
import json

search_engines = {}
search_engines_patterns = []

def decode(value):
    if value == "NULL":
        return None

    try:
        return int(value)
    except:
        pass

    if value[0] == '\'' and value[-1] == '\'':
        return value[1:-1].replace("\\\\", "\\")

    return value

def parse_SearchEngines(dump_filename):
    result = []
    for sql in open(dump_filename, encoding="utf8"):
        if "INSERT" in sql:
            parsed = sqlparse.parse(sql)
            exp = parsed[0].tokens[8].tokens[1].tokens
            obj = {}
            obj["Id"]                   = decode(exp[0].value)
            obj["SearchEngine"]         = decode(exp[2].value)
            obj["ParentId"]             = decode(exp[4].value)
            obj["weight"]               = decode(exp[6].value)
            obj["URL"]                  = decode(exp[8].value)
            obj["form_num"]             = decode(exp[10].value)
            obj["field_name"]           = decode(exp[12].value)
            obj["Hide"]                 = decode(exp[14].value)
            obj["CheckType"]            = decode(exp[16].value)
            obj["PageParameterPattern"] = decode(exp[18].value)
            obj["PageParameterOffset"]  = decode(exp[20].value)
            obj["PageParameterDivisor"] = decode(exp[22].value)
            obj["StrId"]                = decode(exp[24].value)
            obj["Domain"]               = decode(exp[26].value)
            result.append(obj)
    return result

def parse_SearchEnginesPatterns(dump_filename):
    result = []
    for sql in open(dump_filename, encoding="utf8"):
        if "INSERT" in sql:
            parsed = sqlparse.parse(sql.strip())
            exp = parsed[0].tokens[8].tokens[1].tokens
            obj = {}
            obj["Id"]               = decode(exp[0].value)
            obj["SearchEngineId"]   = decode(exp[2].value)
            obj["Pattern"]          = decode(exp[4].value)
            obj["QuickPattern"]     = decode(exp[6].value)
            obj["Charset"]          = decode(exp[8].value)
            result.append(obj)
    return result

def write_json(dump_filename, parse_method):
    with open(dump_filename.replace(".sql", ".json"), "w") as f:
        f.write(json.dumps(parse_method(dump_filename), indent=4))

if __name__ == "__main__":
    #svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/metrika/core/db_dumps/Metrica/SearchEngines.sql
    write_json("SearchEngines.sql", parse_SearchEngines)

    #svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/metrika/core/db_dumps/Metrica/SearchEngines_Patterns.sql
    write_json("SearchEngines_Patterns.sql", parse_SearchEnginesPatterns)
