#pragma once

#include <util/generic/deque.h>
#include <util/generic/string.h>

namespace NWebmaster {
namespace NAcceptance {

bool IsThresholdBroken(const TString &name, TDeque<double> &diffs, const TMap<double, TString> &samples, double percentile, double threshold);
void AddSample(TDeque<double> &diffs, TMap<double, TString> &samples, double diff, const TString &host, size_t keepSamples = 50);
void HostinfoLog(const TString &msg, const TString &source = "");
bool ParseDate(NYT::TNode node, time_t &time);
}
} //namespace NWebmaster
