#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/conf/yt.h>
#include <wmconsole/version3/searchqueries-mr/conf/yt.h>

namespace NWebmaster {
namespace NAcceptance {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        TCustomYTEnvironment::Instance().Init("prod");

        MR_SERVER_HOST_ANTIALL                          = "arnold.yt.yandex.net";
        MR_SERVER_DISALLOWED_URLS                       = "hahn.yt.yandex.net";

        ATTR_UPDATE_TIME                                = "update_time";
        ATTR_MODIFICATION_TIME                          = "modification_time";
        ATTR_FULL_HOST_COUNT                            = "full_host_count";
        ATTR_DIFF_HOST_COUNT                            = "diff_host_count";
        ATTR_CHANGES_SHARE                              = "changes_share";
        ATTR_ACCEPTED                                   = "accepted";
        ATTR_FORCE_ACCEPT                               = "force_accept";
        ATTR_JUPITER_DESSERT_PREV_STATE                 = "jupiter_meta/dessert_prev_state";
        ATTR_JUPITER_PRODUCTION_CURRENT_STATE           = "jupiter_meta/production_current_state";
        ATTR_LAST_COMPARED_TABLES                       = "last_compared_tables";
        ATTR_LAST_PROCESSED_TABLES                      = "last_processed_tables";

        MR_SERVER_HOST                                  = TCommonYTConfigSQ::CInstance().MR_SERVER_HOST_USER_SESSIONS;
        TABLE_ACCEPTANCE_ROOT                           = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "acceptance");
        TABLE_SITEMAP_ROOT                              = NYTUtils::JoinPath(TCommonYTConfig::CInstance().TABLE_ROOT, "sitemap");
        TABLE_ACCEPTANCE_TOP_HOSTS                      = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "top_hosts");
        TABLE_ACCEPTANCE_MIRRORS_ROOT                   = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "jupiter", "mirrors");

        TABLE_ACCEPTANCE_MIRRORS_DIFF_ROOT              = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "mirrors", "diff");
        TABLE_ACCEPTANCE_MIRRORS_STATISTICS             = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "mirrors", "statistics");

        TABLE_ACCEPTANCE_HOSTTABLE_ROOT                 = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "hosttable2");
        TABLE_ACCEPTANCE_URLS_FOR_WEBMASTER_SIMPLE_ROOT = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "urls_for_webmaster_simple");
        TABLE_ACCEPTANCE_SPREAD_EXPORT_HOSTDAT_ROOT     = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "spread_export_hostdat");
        TABLE_ACCEPTANCE_SPREAD_EXPORT_URLDAT_ROOT      = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "spread_export_urldat");
        TABLE_ACCEPTANCE_CONTENT_ATTRS_ROOT             = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "content_attrs");

        TABLE_ACCEPTANCE_SITEMAP_ROOT                   = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "sitemap");
        TABLE_ACCEPTANCE_HOST_DATA_WEBMASTER_ROOT       = NYTUtils::JoinPath(TABLE_ACCEPTANCE_SITEMAP_ROOT, "host_data_webmaster");

        TABLE_ACCEPTANCE_SITEMAP_DATA_WEBMASTER_ROOT       = NYTUtils::JoinPath(TABLE_ACCEPTANCE_SITEMAP_ROOT, "sitemap_data_webmaster");

        TABLE_ACCEPTANCE_ANTI_DIFF_ROOT                 = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "antiall", "diff");
        TABLE_ACCEPTANCE_ANTI_PREVIOUS_ROOT             = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "antiall", "previous");
        TABLE_ACCEPTANCE_ANTI_CURRENT_ROOT              = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "antiall", "current");
        TABLE_ACCEPTANCE_ANTI_STATISTICS_ROOT           = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "antiall", "statistics");

        TABLE_ACCEPTANCE_ANTI_ANTISPAM_DIFF             = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ANTI_DIFF_ROOT, "antispam");
        TABLE_ACCEPTANCE_ANTI_ANTISPAM_SNAPSHOT_PREV    = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ANTI_PREVIOUS_ROOT, "antispam");
        TABLE_ACCEPTANCE_ANTI_ANTISPAM_STATISTICS       = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ANTI_STATISTICS_ROOT, "antispam");

        TABLE_ACCEPTANCE_ANTI_ANTIVIR_DIFF              = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ANTI_DIFF_ROOT, "antivir");
        TABLE_ACCEPTANCE_ANTI_ANTIVIR_SNAPSHOT_PREV     = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ANTI_PREVIOUS_ROOT, "antivir");
        TABLE_ACCEPTANCE_ANTI_ANTIVIR_STATISTICS        = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ANTI_STATISTICS_ROOT, "antivir");

        TABLE_ACCEPTANCE_DISALLOWED_URLS_ROOT           = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "disallowed_urls_alert");
        TABLE_ACCEPTANCE_HOSTINFO_ROOT                  = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "hostinfo");
        TABLE_ACCEPTANCE_HOSTINFO_ARCHIVE               = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/archive");
        TABLE_ACCEPTANCE_HOSTINFO_STATUS_ARCHIVE        = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/archive_status");

        TABLE_ACCEPTANCE_HOSTINFO_STATISTICS            = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/statistics");
        TABLE_ACCEPTANCE_HOSTINFO_STATUS                = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/status");
        TABLE_ACCEPTANCE_HOSTINFO_REGIONS               = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/regions");
        TABLE_ACCEPTANCE_HOSTINFO_FACE_PROBLEM          = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/face_problem");
        TABLE_ACCEPTANCE_HOSTINFO_FACE_PROBLEM_ARCHIVE  = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/archive_face_problem");
        TABLE_ACCEPTANCE_HOSTINFO_REGIONS_ARCHIVE       = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/archive_regions");
        TABLE_ACCEPTANCE_HOSTINFO_PROBLEMS              = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/problems");
        TABLE_ACCEPTANCE_HOSTINFO_PROBLEMS_ARCHIVE      = NYTUtils::JoinPath(TABLE_ACCEPTANCE_HOSTINFO_ROOT, "hostinfo/archive_problems");
        TABLE_ACCEPTANCE_ROBOTS_ROOT                    = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "robots");
        TABLE_ACCEPTANCE_ROBOTS_ARCHIVE                 = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROBOTS_ROOT, "archive");
        TABLE_ACCEPTANCE_ROBOTS_STATISTICS              = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROBOTS_ROOT, "statistics");

        TABLE_ACCEPTANCE_ACHIEVEMENTS_ROOT              = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ROOT, "achievements");
        TABLE_ACCEPTANCE_ACHIEVEMENTS_RU                = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ACHIEVEMENTS_ROOT, "achievements");
        TABLE_ACCEPTANCE_ACHIEVEMENTS_RU_NUMERIC        = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ACHIEVEMENTS_ROOT, "achievements.num");
        TABLE_ACCEPTANCE_ACHIEVEMENTS_KUUB              = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ACHIEVEMENTS_ROOT, "achievements.kuub");
        TABLE_ACCEPTANCE_ACHIEVEMENTS_KUUB_NUMERIC      = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ACHIEVEMENTS_ROOT, "achievements.kuub.num");
        TABLE_ACCEPTANCE_ACHIEVEMENTS_ARCHIVE           = NYTUtils::JoinPath(TABLE_ACCEPTANCE_ACHIEVEMENTS_ROOT, "achievements.archive");

        TABLE_ACCEPTANCE_DISALLOWED_URLS_FILTERED         = NYTUtils::JoinPath(TABLE_ACCEPTANCE_DISALLOWED_URLS_ROOT, "filtered_urls");
        TABLE_ACCEPTANCE_DISALLOWED_URLS_FILTERED_ARCHIVE = NYTUtils::JoinPath(TABLE_ACCEPTANCE_DISALLOWED_URLS_ROOT, "archive_filtered_urls");

        TABLE_SRC_ANTISPAM                              = "//home/antispam/export/webmaster/threats";
        TABLE_SRC_ANTIVIR                               = "//home/antivir/prod/export/urls_for_webmaster";
        HOME_JUPITER                                    = "//home/jupiter";
        TABLE_WEBMATER_HOSTS                            = TCommonYTConfig::CInstance().TABLE_SOURCE_WEBMASTER_HOSTS;
    }

public:
    const float OPERATION_WEIGHT = 1.0f;
    TString MR_SERVER_HOST_ANTIALL;
    TString MR_SERVER_HOST;
    TString ATTR_ACCEPTED;
    TString ATTR_UPDATE_TIME;
    TString ATTR_FORCE_ACCEPT;
    TString ATTR_MODIFICATION_TIME;
    TString ATTR_FULL_HOST_COUNT;
    TString ATTR_DIFF_HOST_COUNT;
    TString ATTR_CHANGES_SHARE;
    TString ATTR_JUPITER_DESSERT_PREV_STATE;
    TString ATTR_JUPITER_PRODUCTION_CURRENT_STATE;
    TString ATTR_LAST_COMPARED_TABLES;
    TString ATTR_LAST_PROCESSED_TABLES;
    TString TABLE_ACCEPTANCE_ROOT;
    TString TABLE_SITEMAP_ROOT;
    TString TABLE_ACCEPTANCE_TOP_HOSTS;
    TString TABLE_ACCEPTANCE_MIRRORS_ROOT;
    TString TABLE_ACCEPTANCE_ANTI_DIFF_ROOT;
    TString TABLE_ACCEPTANCE_ANTI_CURRENT_ROOT;
    TString TABLE_ACCEPTANCE_ANTI_PREVIOUS_ROOT;
    TString TABLE_ACCEPTANCE_ANTI_STATISTICS_ROOT;
    TString TABLE_ACCEPTANCE_MIRRORS_DIFF_ROOT;
    TString TABLE_ACCEPTANCE_MIRRORS_STATISTICS;
    TString TABLE_ACCEPTANCE_HOSTTABLE_ROOT;
    TString TABLE_ACCEPTANCE_SITEMAP_ROOT;
    TString TABLE_ACCEPTANCE_HOST_DATA_WEBMASTER_ROOT;
    TString TABLE_ACCEPTANCE_SITEMAP_DATA_WEBMASTER_ROOT;
    TString TABLE_ACCEPTANCE_URLS_FOR_WEBMASTER_SIMPLE_ROOT;
    TString TABLE_ACCEPTANCE_SPREAD_EXPORT_HOSTDAT_ROOT;
    TString TABLE_ACCEPTANCE_SPREAD_EXPORT_URLDAT_ROOT;
    TString TABLE_ACCEPTANCE_CONTENT_ATTRS_ROOT;
    TString TABLE_ACCEPTANCE_ANTI_ANTISPAM_DIFF;
    TString TABLE_ACCEPTANCE_ANTI_ANTISPAM_SNAPSHOT_PREV;
    TString TABLE_ACCEPTANCE_ANTI_ANTISPAM_STATISTICS;
    TString TABLE_ACCEPTANCE_ANTI_ANTIVIR_DIFF;
    TString TABLE_ACCEPTANCE_ANTI_ANTIVIR_SNAPSHOT_PREV;
    TString TABLE_ACCEPTANCE_ANTI_ANTIVIR_STATISTICS;
    TString TABLE_ACCEPTANCE_HOSTINFO_ROOT;
    TString TABLE_ACCEPTANCE_HOSTINFO_ARCHIVE;
    TString TABLE_ACCEPTANCE_HOSTINFO_STATUS_ARCHIVE;
    TString TABLE_ACCEPTANCE_HOSTINFO_STATISTICS;
    TString TABLE_ACCEPTANCE_HOSTINFO_STATUS;
    TString TABLE_ACCEPTANCE_HOSTINFO_REGIONS;
    TString TABLE_ACCEPTANCE_HOSTINFO_FACE_PROBLEM;
    TString TABLE_ACCEPTANCE_HOSTINFO_PROBLEMS;
    TString TABLE_ACCEPTANCE_HOSTINFO_PROBLEMS_ARCHIVE;
    TString TABLE_ACCEPTANCE_HOSTINFO_FACE_PROBLEM_ARCHIVE;
    TString TABLE_ACCEPTANCE_HOSTINFO_REGIONS_ARCHIVE;
    TString TABLE_ACCEPTANCE_ROBOTS_ROOT;
    TString TABLE_ACCEPTANCE_ROBOTS_ARCHIVE;
    TString TABLE_ACCEPTANCE_ROBOTS_STATISTICS;
    TString TABLE_ACCEPTANCE_DISALLOWED_URLS_ROOT;
    TString TABLE_ACCEPTANCE_DISALLOWED_URLS_FILTERED;
    TString TABLE_ACCEPTANCE_DISALLOWED_URLS_FILTERED_ARCHIVE;
    TString TABLE_ACCEPTANCE_ACHIEVEMENTS_ROOT;
    TString TABLE_ACCEPTANCE_ACHIEVEMENTS_ARCHIVE;
    TString TABLE_ACCEPTANCE_ACHIEVEMENTS_RU;
    TString TABLE_ACCEPTANCE_ACHIEVEMENTS_RU_NUMERIC;
    TString TABLE_ACCEPTANCE_ACHIEVEMENTS_KUUB;
    TString TABLE_ACCEPTANCE_ACHIEVEMENTS_KUUB_NUMERIC;
    TString TABLE_SRC_ANTISPAM;
    TString TABLE_SRC_ANTIVIR;
    TString HOME_JUPITER;
    TString TABLE_WEBMATER_HOSTS;
    TString MR_SERVER_DISALLOWED_URLS;
    double ANTISPAM_THRESHOLD = 0.1;
    double ANTIVIR_THRESHOLD = 0.04;
};

} //namespace NAcceptance
} //namespace NWebmaster
