#include <util/stream/output.h>
#include <library/cpp/string_utils/url/url.h>

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/getopt/last_getopt.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/processors/acceptance/conf/config.h>
#include <wmconsole/version3/wmcutil/args.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include "task_antispam.h"
#include "task_hostinfo.h"
#include "task_mirrors2.h"
#include "task_sitemap.h"
#include "task_robots.h"
#include "task_traffic.h"
#include "task_disallowed_urls.h"
#include "jupiter_acceptance.h"
#include "achievements.h"


namespace NWebmaster {

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);
    using namespace NWebmaster;
    using namespace NWebmaster::NAcceptance;

    NLastGetopt::TOpts opts;
    TString envRoot;

    opts.AddCharOption('L', "Log path").StoreResult(&TArgs::Instance().LogPath).DefaultValue("");

    opts
        .AddCharOption('E', "Environment root")
        .StoreResult(&envRoot)
        .DefaultValue("prod")
    ;

    TVector<TString> optsForSubtasks{"mode"};
    for (const auto& i: optsForSubtasks) {
        opts.AddLongOption(i).DefaultValue("");
    }

    TModChooser modChooser;
    modChooser.AddMode("AcceptAntiall", AcceptAntiall, "AcceptAntiall");
    modChooser.AddMode("AcceptHostinfo", AcceptHostInfo, "AcceptHostinfo");
    modChooser.AddMode("AcceptMirrors", AcceptanceMirrors2, "AcceptMirrors");
    modChooser.AddMode("AcceptRobots", AcceptRobots, "AcceptRobots");
    modChooser.AddMode("UpdateTopHosts", UpdateTopHosts, "UpdateTopHosts");
    modChooser.AddMode("AcceptJupiter", AcceptanceJupiter, "AcceptJupiter");
    modChooser.AddMode("AcceptDisallowedUrls", AcceptDisallowedUrls, "AcceptDisallowedUrls");
    modChooser.AddMode("AcceptanceSitemap", AcceptanceSitemap, "AcceptanceSitemap");
    modChooser.AddMode("AcceptAchievements", AcceptAchievements, "AcceptAchievements");

    opts.SetFreeArgDefaultTitle("Task");
    opts.SetFreeArgsMin(1);
    NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    TVector<TString> modeArgs = { res.GetProgramName() };
    TVector<TString> freeArgs = res.GetFreeArgs();
    modeArgs.insert(modeArgs.end(), freeArgs.begin(), freeArgs.end());
    for (const auto& opt: optsForSubtasks) {
        modeArgs.push_back("--" + opt);
        modeArgs.push_back(res.Get<TString>(opt));
    }

    TCustomYTEnvironment::Instance().Init(envRoot);
    TLogger::Instance();

    NYT::IClientPtr client = NYT::CreateClient(TConfig::CInstance().MR_SERVER_HOST);
    NYTUtils::CreatePath(client, TConfig::CInstance().TABLE_ACCEPTANCE_ROOT);
    NYTUtils::CreatePath(client, TConfig::CInstance().TABLE_ACCEPTANCE_MIRRORS_ROOT);
    NYTUtils::CreatePath(client, TConfig::CInstance().TABLE_ACCEPTANCE_ANTI_CURRENT_ROOT);
    NYTUtils::CreatePath(client, TConfig::CInstance().TABLE_ACCEPTANCE_ANTI_PREVIOUS_ROOT);
    NYTUtils::CreatePath(client, TConfig::CInstance().TABLE_ACCEPTANCE_ANTI_DIFF_ROOT);
    NYTUtils::CreatePath(client, TConfig::CInstance().TABLE_ACCEPTANCE_ANTI_STATISTICS_ROOT);

    return modChooser.Run(modeArgs);
}
