use arnold;

$table_paths = (
    SELECT AGGREGATE_LIST(Path) FROM (SELECT Path
    FROM FOLDER(`//home/webmaster/prod/acceptance/mirrors/diff`) ORDER BY Path DESC LIMIT 20, 20)
);

DEFINE ACTION $process() AS
    INSERT INTO `//home/webmaster/prod/acceptance/mirrors/all_diffs` WITH TRUNCATE
    SELECT * FROM (SELECT TableName() AS State, Host, PrevMainMirror, NewMainMirror FROM EACH($table_paths) UNION ALL
    SELECT State, Host, PrevMainMirror, NewMainMirror FROM `//home/webmaster/prod/acceptance/mirrors/all_diffs`) ORDER BY State, Host;

    EVALUATE FOR $i IN $table_paths DO BEGIN
        DROP TABLE $i;
    END DO;
END DEFINE;

EVALUATE IF ListLength($table_paths) > 0
    DO $process()
