#include <util/draft/date.h>
#include <util/random/random.h>
#include <util/string/join.h>
#include <util/string/printf.h>

#include <mapreduce/yt/interface/protos/yamr.pb.h>

#include <robot/library/yt/static/command.h>
#include <robot/library/yt/static/table.h>
#include <robot/library/yt/static/tags.h>

#include <wmconsole/version3/library/jupiter/jupiter.h>
#include <wmconsole/version3/searchqueries-mr/conf/yt.h>
#include <wmconsole/version3/searchqueries-mr/protos/user_sessions.pb.h>
#include <wmconsole/version3/processors/acceptance/conf/config.h>
#include <wmconsole/version3/processors/acceptance/protos/acceptance.pb.h>
#include <wmconsole/version3/processors/indexing/hostinfo/conf/config.h>
#include <wmconsole/version3/processors/indexing/hostinfo/protos/hostinfo.pb.h>
#include <wmconsole/version3/wmcutil/log.h>
#include <wmconsole/version3/wmcutil/yt/triggers.h>

#include "common.h"
#include "task_hostinfo.h"
#include "host_statistics_common.h"
#include "host_status_common.h"
#include "host_problems_common.h"
#include "host_face_problem_common.h"
#include "host_regions_common.h"

namespace NWebmaster {
namespace NAcceptance {

using namespace NJupiter;

int AcceptHostInfo(int, const char **) {
    NYT::IClientPtr client = NYT::CreateClient(TCommonYTConfigSQ::CInstance().MR_SERVER_HOST_USER_SESSIONS);

    // divide acceptances of separate tables
    auto functions = {
        AcceptHostStatistics,
        AcceptHostStatus,
        AcceptHostProblems,
        AcceptHostFaceProblem,
        AcceptHostRegions,
    };

    NYT::ITransactionPtr tx = client->StartTransaction();

    for (const auto &f: functions) {
        f(tx);
    }

    tx->Commit();

    return 0;
}

} //namespace NAcceptance
} //namespace NWebmaster
