#pragma once

#include <util/generic/singleton.h>

#include <wmconsole/version3/library/env/yt.h>
#include <wmconsole/version3/wmcutil/config_base.h>

namespace NWebmaster {
namespace NAchievements {

struct TConfig {
    static const TConfig &CInstance() {
        return *Singleton<TConfig>();
    }

    TConfig() {
        const TProdYTEnvironment prodEnv;

        ATTR_UPDATE_SOURCE                              = "update_source";
        ATTR_UPDATE_TIME                                = "update_time";
        ATTR_UPLOAD_TS                                  = "upload_ts";
        ATTR_UPLOAD_TIME                                = "upload_time";
        ATTR_CREATE_TIME                                = "creation_time";

        MR_SERVER_HOST                                  = "arnold.yt.yandex.net";

        TABLE_SOURCE_ACHIEVEMENTS                       = "//home/antispam/export/webmaster/achievements";
        TABLE_SOURCE_ACHIEVEMENTS_KUUB                  = "//home/antispam/export/webmaster/achievements.kuub";
        TABLE_SOURCE_IKS                                = "//home/webmaster/prod/iks/IKS";
        TABLE_SOURCE_VIDEOHOSTINGS_GRADES               = "//home/webmaster/prod/export/videohostings/tiers";
        TABLE_SOURCE_VIDEOHOSTINGS_OFFERS               = "//home/webmaster/prod/export/videohostings/videohost_offers_current";

        TABLE_ACHIEVEMENTS_ROOT                         = NYTUtils::JoinPath(prodEnv.TABLE_ENV_ROOT, "achievements");

        TABLE_ACHIEVEMENTS_PREP_ROOT                    = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_ROOT, "sources");
        TABLE_ACHIEVEMENTS_PREP_RU                      = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_PREP_ROOT, "achievements");
        TABLE_ACHIEVEMENTS_PREP_KUUB                    = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_PREP_ROOT, "achievements.kuub");
        TABLE_ACHIEVEMENTS_PREP_SEARCHBASE              = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_PREP_ROOT, "searchbase");
        TABLE_ACHIEVEMENTS_PREP_IKS                     = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_PREP_ROOT, "iks");
        TABLE_ACHIEVEMENTS_PREP_VIDEOHOSTINGS           = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_PREP_ROOT, "videohostings");

        TABLE_ACHIEVEMENTS_EXPORT_RU                    = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_ROOT, "achievements");
        TABLE_ACHIEVEMENTS_EXPORT_KUUB                  = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_ROOT, "achievements.kuub");

        TABLE_QUALITY_ROOT                              = NYTUtils::JoinPath(TABLE_ACHIEVEMENTS_ROOT, "quality");
        TABLE_QUALITY_RIVALS_ROOT                       = NYTUtils::JoinPath(TABLE_QUALITY_ROOT, "rivals");
        TABLE_QUALITY_RIVALS_SPYLOG                     = NYTUtils::JoinPath(TABLE_QUALITY_RIVALS_ROOT, "spylog");
        TABLE_QUALITY_RIVALS_SG                         = NYTUtils::JoinPath(TABLE_QUALITY_RIVALS_ROOT, "similargroup");
        TABLE_QUALITY_RIVALS_SERP                       = NYTUtils::JoinPath(TABLE_QUALITY_RIVALS_ROOT, "serp");
        TABLE_QUALITY_RIVALS_GENERATED                  = NYTUtils::JoinPath(TABLE_QUALITY_RIVALS_ROOT, "generated");

        TABLE_QUALITY_MODELS_ROOT                       = NYTUtils::JoinPath(TABLE_QUALITY_ROOT, "models");
        TABLE_QUALITY_MODELS_SG_FILTERED                = NYTUtils::JoinPath(TABLE_QUALITY_MODELS_ROOT, "sg-filtered");
        TABLE_QUALITY_MODELS_SERP                       = NYTUtils::JoinPath(TABLE_QUALITY_MODELS_ROOT, "serp");
    }

public:
    const float OPERATION_WEIGHT = 1.0f;
    TString MR_SERVER_HOST;

    TString ATTR_UPDATE_SOURCE;
    TString ATTR_UPDATE_TIME;
    TString ATTR_UPLOAD_TS;
    TString ATTR_UPLOAD_TIME;
    TString ATTR_CREATE_TIME;

    TString TABLE_SOURCE_ACHIEVEMENTS;
    TString TABLE_SOURCE_ACHIEVEMENTS_KUUB;
    TString TABLE_SOURCE_IKS;
    TString TABLE_SOURCE_VIDEOHOSTINGS_GRADES;
    TString TABLE_SOURCE_VIDEOHOSTINGS_OFFERS;

    TString TABLE_ACHIEVEMENTS_ROOT;
    TString TABLE_ACHIEVEMENTS_EXPORT_RU;
    TString TABLE_ACHIEVEMENTS_EXPORT_KUUB;

    TString TABLE_ACHIEVEMENTS_PREP_ROOT;
    TString TABLE_ACHIEVEMENTS_PREP_RU;
    TString TABLE_ACHIEVEMENTS_PREP_KUUB;
    TString TABLE_ACHIEVEMENTS_PREP_SEARCHBASE;
    TString TABLE_ACHIEVEMENTS_PREP_IKS;
    TString TABLE_ACHIEVEMENTS_PREP_VIDEOHOSTINGS;

    TString TABLE_QUALITY_ROOT;
    TString TABLE_QUALITY_RIVALS_ROOT;
    TString TABLE_QUALITY_RIVALS_SPYLOG;
    TString TABLE_QUALITY_RIVALS_SG;
    TString TABLE_QUALITY_RIVALS_SERP;
    TString TABLE_QUALITY_RIVALS_GENERATED;

    TString TABLE_QUALITY_MODELS_ROOT;
    TString TABLE_QUALITY_MODELS_SG_FILTERED;
    TString TABLE_QUALITY_MODELS_SERP;
};

} // namespace NAchievements
} //namespace NWebmaster
