#include <util/stream/output.h>

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/getopt/last_getopt.h>

#include <mapreduce/yt/interface/client.h>

#include <wmconsole/version3/wmcutil/yt/yt_utils.h>

#include <wmconsole/version3/processors/achievements/conf/config.h>

#include "task_about_iks.h"
#include "task_generate_rivals.h"
#include "task_merge.h"
#include "task_searchbase.h"
#include "task_videohostings.h"

namespace NWebmaster {

} //namespace NWebmaster

int main(int argc, const char **argv) {
    NYT::Initialize(argc, argv);
    using namespace NWebmaster;

    TCustomYTEnvironment::Instance().Init("prod");

    TModChooser modChooser;
    modChooser.AddMode("Merge", TaskMerge, "Merge achievements");

    modChooser.AddMode("SearchBase", TaskSearchBase, "Prepare search base data");
    modChooser.AddMode("Iks", AboutIks, "Prepare iks data");
    modChooser.AddMode("GenerateRivals", TaskGenerateRivals, "Generate rivals");
    modChooser.AddMode("Videohostings", TaskVideohostings, "Videohostings data");

    return modChooser.Run(argc, argv);
}
