use hahn;
pragma yt.ForceInferSchema;

$report100k = (
    select
        (Top < 1000) as Top1k,
        (Top < 10000) as Top10k,
        (Top < 30000) as Top30k,
        (Top < 100000) as Top100k,
        (CommercialTop < 1000) as CmTop1k,
        (CommercialTop < 10000) as CmTop10k,
        (CommercialTop < 30000) as CmTop30k,
        (CommercialTop < 100000) as CmTop100k,
        report.*
    from concat(
        [//home/webmaster/prod/b2b-top/report/all/owners/20180201_20180301],
        [//home/webmaster/prod/b2b-top/report/all/owners/20180301_20180401],
        [//home/webmaster/prod/b2b-top/report/all/owners/20180401_20180501],
        [//home/webmaster/prod/b2b-top/report/all/owners/20180501_20180601]
    ) as report
    where Top < 100000 or CommercialTop < 100000
);

$selected_tops = (
    select
        SelectedTop,
        CommercialSegment,
        [st.report.Name] as Name,
        [st.report.Commercial] as Commercial,
        [st.report.Chats] as Chats,
        [st.report.Clicks] as Clicks,
        [st.report.Dialogs] as Dialogs,
        [st.report.Period] as Period,
        [st.report.Share] as Share,
        [st.report.Skills] as Skills,
        [st.report.Sprav] as Sprav,
        [st.report.Turbo] as Turbo,
        [st.report.TurboClicks] as TurboClicks,
        [st.report.TurboPages] as TurboPages
    from (
                  select "None" as CommercialSegment, "Top1k" as SelectedTop, st.* from $report100k as st where Top1k = true
        union all select "None" as CommercialSegment, "Top10k" as SelectedTop, st.* from $report100k as st where Top10k = true
        union all select "None" as CommercialSegment, "Top30k" as SelectedTop, st.* from $report100k as st where Top30k = true
        union all select "None" as CommercialSegment, "Top100k" as SelectedTop, st.* from $report100k as st where Top100k = true
        union all select "CmMascot" as CommercialSegment, "Top1k" as SelectedTop, st.* from $report100k as st where CmTop1k = true
        union all select "CmMascot" as CommercialSegment, "Top10k" as SelectedTop, st.* from $report100k as st where CmTop10k = true
        union all select "CmMascot" as CommercialSegment, "Top30k" as SelectedTop, st.* from $report100k as st where CmTop30k = true
        union all select "CmMascot" as CommercialSegment, "Top100k" as SelectedTop, st.* from $report100k as st where CmTop100k = true
    )
);

insert into [//home/webmaster/prod/b2b-top/report/tops/owners] with truncate
select CommercialSegment as commercial_segment, Service as service, SelectedTop as selected_top, Period as fielddate, Owners as owners, TrafficShare as traffic_share from (
    select "turbo" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare
    from $selected_tops
    where Turbo = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "sprav" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare
    from $selected_tops
    where Sprav = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "chats" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare
    from $selected_tops
    where Chats = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "dialogs" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare
    from $selected_tops
    where Dialogs = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "skills" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare
    from $selected_tops
    where Skills = true
    group by CommercialSegment, Period, SelectedTop
) order by commercial_segment, service, fielddate, selected_top;

insert into [//home/webmaster/prod/b2b-top/report/tops/owners-turbo] with truncate
select Service as service, CommercialSegment as commercial_segment, SelectedTop as selected_top, Period as fielddate, Owners as owners, TrafficShare as traffic_share, TurboClicks as turbo_clicks, TurboPages as turbo_pages from (
    select "turbo" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TurboClicks) as TurboClicks, sum(TurboPages) as TurboPages
    from $selected_tops
    where Turbo = true
    group by CommercialSegment, Period, SelectedTop
) order by commercial_segment, service, fielddate, selected_top;
