use hahn;
pragma yt.ForceInferSchema;

$report = (
    select
        (Top < 1000) as Top1k,
        (Top < 10000) as Top10k,
        (Top < 30000) as Top30k,
        (Top < 100000) as Top100k,
        (CommercialTop < 1000) as CmTop1k,
        (CommercialTop < 10000) as CmTop10k,
        (CommercialTop < 30000) as CmTop30k,
        (CommercialTop < 100000) as CmTop100k,
        cast(Clicks as double) as DClicks,
        report.*
    from range(
        [//home/webmaster/prod/b2b-top/weekly/report/all/owners]
    ) as report
);

$shares = (
    select
        [report.Period] as Period,
        sum(DClicks) as AllClicks,
        sum(case when [report.Top] < 100000 then DClicks else 0.0 end) as Top100kClicks,
        sum(case when [report.Top] < 30000 then DClicks else 0.0 end) as Top30kClicks,
        sum(case when [report.Top] < 10000 then DClicks else 0.0 end) as Top10kClicks,
        sum(case when [report.Top] < 1000 then DClicks else 0.0 end) as Top1kClicks,
        sum(case when [report.Commercial] == true then DClicks else 0.0 end) as AllCmClicks,
        sum(case when [report.CommercialTop] < 100000 then DClicks else 0.0 end) as CmTop100kClicks,
        sum(case when [report.CommercialTop] < 30000 then DClicks else 0.0 end) as CmTop30kClicks,
        sum(case when [report.CommercialTop] < 10000 then DClicks else 0.0 end) as CmTop10kClicks,
        sum(case when [report.CommercialTop] < 1000 then DClicks else 0.0 end) as CmTop1kClicks
    from $report
    group by [report.Period]
);

$selected_tops = (
    select
        SelectedTop,
        CommercialSegment,
        Share,
        TopShare,
        [st.report.Name] as Name,
        [st.report.Commercial] as Commercial,
        [st.report.Chats] as Chats,
        [st.report.Clicks] as Clicks,
        [st.report.Dialogs] as Dialogs,
        [st.report.Period] as Period,
        [st.report.Skills] as Skills,
        [st.report.Sprav] as Sprav,
        [st.report.Turbo] as Turbo,
        [st.report.Webmaster] as Webmaster,
        [st.report.WebmasterVisitors] as WebmasterVisitors,
        [st.report.TurboClicks] as TurboClicks,
        [st.report.TurboPages] as TurboPages
    from (
                  select "None" as CommercialSegment, "Top1k" as SelectedTop,   (st.[report.Clicks] / sh.AllClicks) as Share, (st.[report.Clicks] / sh.Top1kClicks) as TopShare,    st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where Top1k = true
        union all select "None" as CommercialSegment, "Top10k" as SelectedTop,  (st.[report.Clicks] / sh.AllClicks) as Share, (st.[report.Clicks] / sh.Top10kClicks) as TopShare,   st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where Top10k = true
        union all select "None" as CommercialSegment, "Top30k" as SelectedTop,  (st.[report.Clicks] / sh.AllClicks) as Share, (st.[report.Clicks] / sh.Top30kClicks) as TopShare,   st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where Top30k = true
        union all select "None" as CommercialSegment, "Top100k" as SelectedTop, (st.[report.Clicks] / sh.AllClicks) as Share, (st.[report.Clicks] / sh.Top100kClicks) as TopShare,  st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where Top100k = true
        union all select "Commercial(Mascot)" as CommercialSegment, "Top1k" as SelectedTop,     (st.[report.Clicks] / sh.AllCmClicks) as Share, (st.[report.Clicks] / sh.CmTop1kClicks) as TopShare,    st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where CmTop1k = true
        union all select "Commercial(Mascot)" as CommercialSegment, "Top10k" as SelectedTop,    (st.[report.Clicks] / sh.AllCmClicks) as Share, (st.[report.Clicks] / sh.CmTop10kClicks) as TopShare,   st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where CmTop10k = true
        union all select "Commercial(Mascot)" as CommercialSegment, "Top30k" as SelectedTop,    (st.[report.Clicks] / sh.AllCmClicks) as Share, (st.[report.Clicks] / sh.CmTop30kClicks) as TopShare,   st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where CmTop30k = true
        union all select "Commercial(Mascot)" as CommercialSegment, "Top100k" as SelectedTop,   (st.[report.Clicks] / sh.AllCmClicks) as Share, (st.[report.Clicks] / sh.CmTop100kClicks) as TopShare,  st.* from $report as st join $shares as sh on st.[report.Period] = sh.Period where CmTop100k = true
    )
);

insert into [//home/webmaster/prod/b2b-top/weekly/report/tops/owners] with truncate
select CommercialSegment as commercial_segment, Service as service, SelectedTop as selected_top, Period as fielddate, Owners as owners, TrafficShare as traffic_share, TrafficTopShare as traffic_top_share from (
    select "turbo" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare
    from $selected_tops
    where Turbo = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "sprav" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare
    from $selected_tops
    where Sprav = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "chats" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare
    from $selected_tops
    where Chats = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "dialogs" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare
    from $selected_tops
    where Dialogs = true
    group by CommercialSegment, Period, SelectedTop
    
    union all
    select "skills" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare
    from $selected_tops
    where Skills = true
    group by CommercialSegment, Period, SelectedTop

    union all
    select "webmaster" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare
    from $selected_tops
    where Webmaster = true
    group by CommercialSegment, Period, SelectedTop

    union all
    select "webmaster_visited" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare
    from $selected_tops
    where WebmasterVisitors > 0
    group by CommercialSegment, Period, SelectedTop
) order by commercial_segment, service, fielddate, selected_top;

insert into [//home/webmaster/prod/b2b-top/weekly/report/tops/owners-turbo] with truncate
select Service as service, CommercialSegment as commercial_segment, SelectedTop as selected_top, Period as fielddate, Owners as owners, TrafficShare as traffic_share, TrafficTopShare as traffic_top_share, TurboClicks as turbo_clicks, TurboPages as turbo_pages from (
    select "turbo" as Service, CommercialSegment, SelectedTop, Period, count(*) as Owners, sum(Share) as TrafficShare, sum(TopShare) as TrafficTopShare, sum(TurboClicks) as TurboClicks, sum(TurboPages) as TurboPages
    from $selected_tops
    where Turbo = true
    group by CommercialSegment, Period, SelectedTop
) order by commercial_segment, service, fielddate, selected_top;
