use hahn;

$owned_companies = (
    select company_id as company_id, uid as uid
    from [//home/sprav/tycoon/production/snapshot/companies_acl]

    union all
    select company_id, uid as uid
    from [//home/sprav/tycoon/production/webmaster/company]

    union all select cc.company_id as company_id, uid as uid
    from [//home/sprav/tycoon/production/snapshot/chain_acl] as c 
    join [//home/sprav/tycoon/production/snapshot/chain_company] as cc
        on c.chain_id = cc.chain_id
    where not cc.deleted

    union all
    select cc.company_id as company_id, uid as uid
    from [//home/sprav/tycoon/production/webmaster/chain] as c
    join [//home/sprav/tycoon/production/snapshot/chain_company] as cc
        on c.chain_id = cc.chain_id
);

$owned_company_permalink = (
    select distinct c.permanent_id as permalink, o.uid as uid
    from [//home/sprav/tycoon/production/snapshot/companies] as c
    join $owned_companies as o
        on c.id = o.company_id
    join [//home/sprav/altay/prod/snapshot/company] as cc
        on c.permanent_id = cc.permalink
    where cc.type == 'ordinal' 
        and cc.publishing_status == 'publish'
);

$url_logins = (
    select c.value AS url, coalesce(u.login, '-') as login from [//home/sprav/altay/prod/snapshot/company_to_url] as c
    join $owned_company_permalink as p
        on c.permalink = p.permalink
    left join [//home/sprav/tycoon/production/snapshot/users] as u
        on p.uid = u.id
    where c.hide = False
        and c.type = 'main'
);

insert into [//home/webmaster/prod/b2b-top/weekly/raw/sprav] with truncate
select distinct url, login from $url_logins
order by url;
