use hahn;

$format = DateTime::Format("%Y%m%d");
$parse = DateTime::Parse("%Y%m%d");

define action $process_week($period_begin, $period_end, $output_path) as
    $is_not_dynamic_click = ($x) -> { return $x.is_dynamic = false; };
    
    $is_turbo_click       = ($x) -> { 
        return ($x.vars["preview"] = "true" and $x.converted_path not like "%sideblock%") ?? false;
    };
    
    $normalize_url = ($x) -> {
        $url = Url::CutQueryStringAndFragment($x);
        return case
            when String::EndsWith($url, "/")
            then String::RemoveLast($url, "/")
            else $url
        end;
    };
    
    $extract_url = ($x) -> {
        $is_turbo_url = Url::GetOwner($x) = "yandex.ru" and String::StartsWith(Url::GetPath($x), "/turbo");
        $url = case
            when $is_turbo_url
            then Url::Decode(Url::GetCGIParam($x, "text"))
            else $x
        end;
        return $normalize_url($url);
    };
    
    $is_during_last_week = ($table_name) -> {
        $date = DateTime::MakeTimestamp($parse($table_name));
        return ($date between $period_begin and $period_end) ?? false;
    };

    -- Data
    $raw_clicks = (
        select result.clicks as clicks, result.url as common_url
        from filter(
            `//home/search-functionality/mt_squeeze/v31/click_props`,
            $is_during_last_week
        ) flatten by mainResults as result
        where (ui == 'touch' or ui == 'mobileapp') and String::Contains(result.url, ".")
    );
    
    $processed_clicks = (
        select $extract_url(WeakField(c.url, "String", common_url)) as url, $is_turbo_click(c) as is_turbo
        from $raw_clicks
        flatten by clicks as c
        where $is_turbo_click(c) or $is_not_dynamic_click(c)
    );
    
    $autoparsed_urls = (
        select $normalize_url(Yson::ConvertToString(Yson::ParseJson(value)["url"])) as url
        from `//home/turborss/production/yt_pull_job/history_static`
        where action = "modify" and Yson::ConvertToString(meta["source"]) = "autoparser"
    );
    
    $clicks_with_autoparser_info = (
        select 
            L.url as url,
            L.is_turbo as is_turbo--,
            --(L.is_turbo and R.url is not null) as is_autoparsed
        from $processed_clicks as L
        --left join $autoparsed_urls as R
        --on L.url = R.url
    );
    
    insert into $output_path with truncate
    select 
        domain,
        count_if(is_turbo) as turbo_clicks,
        count(*) as total_clicks--,
        --count_if(is_autoparsed) as autoparsed_clicks
    from $clicks_with_autoparser_info
    group by Url::GetOwner(url) as domain
    having count_if(is_turbo) > 0
    order by domain;
end define;

$today = CurrentUtcDate();
$wd = DateTime::GetDayOfWeek($today);
$period_end1 = $today - $wd * Interval("P1DT");
$period_end2 = $period_end1 + Interval("P1DT");
$period_begin = $period_end2 - Interval("P7DT");

$output_table_name
    = $format($period_begin)
    || "_"
    || $format($period_end2);

$output_directory = "//home/webmaster/prod/b2b-top/weekly/sources/turbo/owners";
$output_path = $output_directory || "/" || $output_table_name;

$week_is_already_processed = (
    select count(*) 
    from folder($output_directory) 
    where String::EndsWith(Path, Unwrap($output_table_name))
);

evaluate if $week_is_already_processed == 0
    do $process_week($period_begin, $period_end1, $output_path);
