use hahn;

$format = DateTime::Format("%Y%m%d");
$parse = DateTime::Parse("%Y%m%d");

define action $process_week($period_begin, $period_end, $output_path) as
    $is_during_last_week = ($table_name) -> {
        $date = DateTime::MakeTimestamp($parse($table_name));
        return ($date between $period_begin and $period_end) ?? false;
    };

    $squezee = (
        select clicks, `date`, host, ui
        from (
            select clicks, `date`, Url::GetHost(clicks.url) as host, ui
            from filter(`//home/search-functionality/mt_squeeze/v31/click_props`, $is_during_last_week)
            flatten by clicks
            where /*ui in ('touch','mobileapp')
            and*/ clicks.vars['preview'] = 'true'
            and not clicks.is_dynamic
        ) flatten by host
    );

    insert into $output_path with truncate
    select domain, ui, count(*) as turbo_clicks
    from $squezee
    group by Url::GetOwner(host) as domain, ui
    order by domain, ui;
    
end define;

$today = CurrentUtcDate();
$wd = DateTime::GetDayOfWeek($today);
$period_end1 = $today - $wd * Interval("P1DT");
$period_end2 = $period_end1 + Interval("P1DT");
$period_begin = $period_end2 - Interval("P7DT");

$output_table_name = $format($period_begin) || "_" || $format($period_end2);

$output_directory = "//home/webmaster/prod/b2b-top/weekly/sources/turbo_v4/owners";
$output_path = $output_directory || "/" || $output_table_name;

$week_is_already_processed = (
    select count(*) 
    from folder($output_directory) 
    where String::EndsWith(Path, Unwrap($output_table_name))
);

evaluate if $week_is_already_processed == 0
    do $process_week($period_begin, $period_end1, $output_path);
