#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import json

try:
    import httplib
except:
    import http.client as httplib

OAUTH_TOKEN = os.getenv("STAT_TOKEN")
HOST = "upload.stat.yandex-team.ru"

def call_stat_api(url, body):
    connection = httplib.HTTPSConnection(HOST)
    connection.request("POST", url, json.dumps(body), {
        'Authorization': 'OAuth {}'.format(OAUTH_TOKEN),
        'Content-Type' : 'application/json'
    })
    response = connection.getresponse()
    return (response.status, response.read())

def create_report(name, title, config):
    print(call_stat_api("/_api/report/config", {
        'config': {
            'user_config': config,
            'title': title,
        },
        'name': name,
        'scale': 'w',
    }))

def delete_report(name):
    print(call_stat_api("/_api/report/delete_report", {
        'name': name,
    }))

def upload_report_data(name, csv_data):
    print(call_stat_api("/_api/report/data", {
        'name': name,
        'scale': 'w',
        'csv_data': csv_data,
    }))

def upload_report_data_yt(name, yt_cluster, yt_table_path):
    print(call_stat_api("/_api/report/yt_data_upload", {
        'name': name,
        'scale': 'w',
        'cluster': yt_cluster,
        'table_path': yt_table_path,
    }))

if __name__ == "__main__":
    REPORT_NAME_ALL = 'Webmaster.All/Others/B2B/TopsAll'
    REPORT_NAME_TURBO = 'Webmaster.All/Others/B2B/TopsTurbo'

    REPORT_CONFIG_ALL = {
        'dimensions': [
            {'fielddate': 'date'},
            {'selected_top': 'string'},
            {'commercial_segment': 'string'},
            {'service': 'string'},
        ],
        'measures': [
            {'traffic_share': 'number'},
            {'traffic_top_share': 'number'},
            {'owners': 'number'},
        ],
        "view_types": {
            "traffic_top_share": {
                "type": "Percentage",
                "precision": "4"
            },
            "traffic_share": {
                "type": "Percentage",
                "precision": "4"
            }
        },
        "titles": {
            "commercial_segment": "Коммерческий сегмент",
            "owners": "Сайты с подключенным сервисом",
            "service": "Сервис",
            "selected_top": "ТОП",
            "traffic_share": "Доля от всего трафика с СЕРПа",
            "traffic_top_share": "Доля от трафика выбранного ТОПа",
        },
    }

    REPORT_CONFIG_TURBO = {
        'dimensions': [
            {'fielddate': 'date'},
            {'selected_top': 'string'},
            {'commercial_segment': 'string'},
        ],
        'measures': [
            {'traffic_share': 'number'},
            {'traffic_top_share': 'number'},
            {'owners': 'number'},
            {'turbo_clicks': 'number'},
            {'turbo_pages': 'number'},
        ],
        "view_types": {
            "traffic_top_share": {
                "type": "Percentage",
                "precision": "4"
            },
            "traffic_share": {
                "type": "Percentage",
                "precision": "4"
            }
        },
        "titles": {
            "commercial_segment": "Коммерческий сегмент",
            "owners": "Сайты с трафиком на Турбо-страницы",
            "selected_top": "ТОП",
            "traffic_share": "Доля от всего трафика с СЕРПа",
            "traffic_top_share": "Доля от трафика выбранного ТОПа",
            "turbo_clicks": "Трафик на Турбо-страницы",
            "turbo_pages": "Количество Турбо-страниц",
        },
    }

    #create_report(REPORT_NAME_ALL, 'B2B Топ (все)', REPORT_CONFIG_ALL)

    #delete_report(REPORT_NAME_TURBO)
    create_report(REPORT_NAME_TURBO, 'B2B Топ (Турбо)', REPORT_CONFIG_TURBO)

    #content = open("5b2be36e9dee760095cc77d4.csv").read()
    #upload_report_data(REPORT_NAME_TURBO, content)
    #upload_report_data('hahn.yt.yandex.net', '//home/webmaster/prod/b2b-top/weekly/report/tops/owners')
