use hahn;

$table_input    = "//home/webmaster/prod/export/checklist/site-problems";
$table_output   = "//home/webmaster/prod/analytics/checklist/site-problems";
$table_history  = "//home/webmaster/prod/analytics/checklist/site-problems-history";
$current_date   = cast(CurrentUtcDate() as String);

$data = (
    select 
        Host,
        $current_date as Period,
        aggregate_list(Problem) as SiteProblems
    from $table_input
    group by Host
);

insert into $table_output
    with truncate
select 
    Host,
    Period,
    SiteProblems
from $data
order by Host;
commit;

insert into $table_history
    with truncate
select 
    Host,
    Period,
    some(SiteProblems) as SiteProblems
from concat($table_output, $table_history)
group by Host, Period
order by Host, Period
