YQL="yql --syntax-version=1"

_scenario() {
    MAIN    analytics_checklist:                restart_on_success="45 */8 * * *" retry_on_failure="24 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru
    MAIN    analytics_favicons_big_count:       restart_on_success="10 11 * * *" retry_on_failure="20 */6 * * *" mailto=wmconsole-dev-alert@yandex-team.ru
    MAIN    analytics_feeds:                    restart_on_success="0 4 * * *" retry_on_failure="0 */3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,kravchenko99@yandex-team.ru
    MAIN    analytics_feeds_sort:               analytics_feeds restart_on_success="0 4 * * *" retry_on_failure="0 4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,kravchenko99@yandex-team.ru
    MAIN    analytics_feeds_stats_transfer:     restart_on_success="0 4 * * *" retry_on_failure="0 */3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_feeds_stats_1:            analytics_feeds_stats_transfer restart_on_success="0 4 * * *" retry_on_failure="0 */3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_feeds_stats_2:            analytics_feeds_stats_transfer restart_on_success="0 4 * * *" retry_on_failure="0 */3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_feeds_stats_vertical_share:            analytics_feeds_stats_transfer restart_on_success="0 4 * * *" retry_on_failure="0 */3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_feeds_stats:              analytics_feeds_stats_1 \
                                                analytics_feeds_stats_2 \
                                                analytics_feeds_stats_vertical_share \
                                                    restart_on_success="0 4 * * *" retry_on_failure="0 */3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_user_sessions:
    MAIN    analytics_engagement_gsc_vs_ywm:    restart_on_success="10 4 */3 * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_export_catalogia_prepare:
    MAIN    analytics_export_catalogia_chart:   analytics_export_catalogia_prepare restart_on_success="24 10 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_export_catalogia_volume:  restart_on_success="50 3 */2 * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_logs_store:               restart_on_success="35 */8 * * *" retry_on_failure="0 18 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_robot_jupiter_meta:       restart_on_success="30 */8 * * *" retry_on_failure="30 8 * * *"
    MAIN    analytics_robot_wmc_10758:          restart_on_success="40 */12 * * *" retry_on_failure="40 12 * * *"
    MAIN    analytics_robot_wmc_11046:          restart_on_success="20 4 * * *" retry_on_failure="20 12 * * *"
    MAIN    analytics_quality:                  restart_on_success="55 */12 * * *" retry_on_failure="35 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru
    MAIN    analytics_mailings_base:            restart_on_success="20 */3 * * *" retry_on_failure="20 3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_metrika:                  restart_on_success="15 */8 * * *" retry_on_failure="15 8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_dev_loc_cassandra_ydb:    restart_on_success="40 */8 * * *" retry_on_failure="40 8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_dev_commits:              restart_on_success="30 */12 * * *" retry_on_failure="30 12 * * *"
    MAIN    analytics_sync:                     analytics_mailings_base analytics_user_sessions restart_on_success="23 10 * * *" retry_on_failure="20 */12 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_digest_daily_users:       restart_on_success="0 15 * * *" retry_on_failure="0 18 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,shabashoff@yandex-team.ru
    MAIN    analytics_support_verification_fails:   restart_on_success="10 12 * * *" retry_on_failure="10 8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru
    MAIN    analytics_survey:                   restart_on_success="45 8 * * *" retry_on_failure="45 8 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,lester@yandex-team.ru,ishalaru@yandex-team.ru
    MAIN    analytics_turbo_settings_history:   restart_on_success="0 */3 * * *" retry_on_failure="0 */3 * * *" mailto=wmconsole-dev-alert@yandex-team.ru
    MAIN    analytics_turbo_features_stat:      restart_on_success="0 12 * * *" retry_on_failure="0 15 * * *" mailto=wmconsole-dev-alert@yandex-team.ru
    MAIN    analytics_niche_universal_stats:    restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_niche_host2vec_stats:     restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_niche_visibility_stats:   restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_niche_porn_stats:         restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_niche_rivals:             analytics_niche_universal_stats \
                                                analytics_niche_host2vec_stats \
                                                analytics_niche_visibility_stats \
                                                analytics_niche_porn_stats \
                                                    restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_last_commercial_owners:             restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_consumption_yt_operations:            restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
    MAIN    analytics_consumption_yt_tables:            restart_on_success="0 */12 * * *" retry_on_failure="0 */4 * * *" mailto=wmconsole-dev-alert@yandex-team.ru,intersection@yandex-team.ru
}

function analytics_checklist {
    ${YQL} -i analytics/checklist/site_problems.sql
}

function analytics_engagement_gsc_vs_ywm {
    ${YQL} -i analytics/engagement/gsc_vs_ywm/daily.sql
    #${YQL} -i analytics/engagement/gsc_vs_ywm/history.sql
    ${YQL} -i analytics/engagement/gsc_vs_ywm/stats.sql
    ${YQL} -i analytics/engagement/gsc_vs_ywm/report.sql
}

function analytics_favicons_big_count {
    ${YQL} -i analytics/favicons/big_favicons_count.sql
}

function analytics_user_sessions {
    ${YQL} -i analytics/user_sessions/28d-hosts.sql
}

function analytics_export_catalogia_prepare {
    ${YQL} -i analytics/user_sessions/exports/catalogia/bs_prepare.sql
}

function analytics_export_catalogia_chart {
    ${YQL} -i analytics/user_sessions/exports/catalogia/bs_chart.sql
}

function analytics_export_catalogia_volume {
    ${YQL} -i analytics/user_sessions/exports/catalogia/exports.sql
}

function analytics_dev_loc_cassandra_ydb {
    analytics/dev/loc_cassandra_ydb.sh
    ${YQL} -i analytics/dev/loc_cassandra_ydb.sql
}

function analytics_dev_commits {
    analytics/dev/commits.sh
    ${YQL} -i analytics/dev/commits.sql
}

function analytics_logs_store {
    ${YQL} -i analytics/logs/deploy/frontend/webmaster-frontend.sql
    ${YQL} -i analytics/logs/deploy/backend/webmaster3.sql
    ${YQL} -i analytics/logs/visits.sql
    # copy back to hahn
    VISITS=//home/webmaster/prod/analytics/logs/webmaster-visits
    transfer-manager add-task --sync --src-cluster arnold --src-table $VISITS --dst-cluster hahn --dst-table $VISITS
    # copy balancer logs
    yt --proxy hahn list //logs/webmaster-front-balancer-log/1d | sort > ./analytics/logs/deploy/frontend/src-balancer-logs
    yt --proxy hahn list //home/webmaster/prod/analytics/logs/deploy/webmaster-front-balancer | sort > ./analytics/logs/deploy/frontend/dst-balancer-logs
    comm -23 ./analytics/logs/deploy/frontend/src-balancer-logs \
             ./analytics/logs/deploy/frontend/dst-balancer-logs | \
             xargs -I{} yt --proxy hahn copy -i //logs/webmaster-front-balancer-log/1d/{} //home/webmaster/prod/analytics/logs/deploy/webmaster-front-balancer/{}
}

function analytics_metrika {
    ${YQL} -i analytics/metrika/visit-v2-log/30468942.sql

    ${YQL} -i analytics/metrika/metrika_bindings.sql

    ${YQL} -i analytics/metrika/metrika_crawl_settings.sql
    CRAWL_SETTINGS=//home/webmaster/prod/analytics/metrika/crawl-settings
    transfer-manager add-task --sync --src-cluster arnold --src-table $CRAWL_SETTINGS --dst-cluster hahn --dst-table $CRAWL_SETTINGS

    ${YQL} -i analytics/metrika/metrika_use_metrika.sql
    USE_METRIKA=//home/webmaster/prod/analytics/metrika/use_metrika
    transfer-manager add-task --sync --src-cluster arnold --src-table $USE_METRIKA --dst-cluster hahn --dst-table $USE_METRIKA

    ${YQL} -i analytics/metrika/metrika_has_metrika.sql
}

function analytics_mailings_base {
    analytics/mailings/mirrors.sh
    ${YQL} -i analytics/mailings/users_emails.sql
    ${YQL} -i analytics/mailings/hosts_verified.sql
    ${YQL} -i analytics/mailings/turbo_settings.sql
    ${YQL} -i analytics/mailings/metrika.sql
    ${YQL} -i analytics/mailings/base.sql
    ${YQL} -i analytics/mailings/history.sql
    ${YQL} -i analytics/mailings/zeropixel.sql
    ${YQL} -i analytics/mailings/messages_sent.sql
    ${YQL} -i analytics/mailings/metrika_visits.sql
    MESSAGES_SENT=//home/webmaster/prod/analytics/mailings/messages_sent_by_type
    transfer-manager add-task --sync --src-cluster arnold --src-table $MESSAGES_SENT --dst-cluster hahn --dst-table $MESSAGES_SENT
    ${YQL} -i analytics/mailings/messages_funnel.sql
}

function analytics_sync {
    USER_SESSIONS_28D_ALL=//home/webmaster/prod/export/analytics/user_sessions/28d-hosts
    MAILINGS_BASE=//home/webmaster/prod/analytics/mailings/base
    COMMERCIAL_OWNERS_SOURCE = //home/commercial/factors/commercial_owners/data/CommercialOwners
    COMMERCIAL_OWNERS_DESTINATION = //home/webmaster/prod/analytics/commercial/CommercialOwners
    transfer-manager add-task --sync \
        --src-cluster arnold --src-table $COMMERCIAL_OWNERS_SOURCE \
         --dst-cluster hahn --dst-table $COMMERCIAL_OWNERS_COMMERCIAL_OWNERS_DESTINATION
    transfer-manager add-task --sync --src-cluster arnold --src-table $USER_SESSIONS_28D_ALL --dst-cluster hahn --dst-table $USER_SESSIONS_28D_ALL
    transfer-manager add-task --sync --src-cluster hahn --src-table $MAILINGS_BASE --dst-cluster arnold --dst-table $MAILINGS_BASE
}

function analytics_digest_daily_users {
     ${YQL} -i analytics/digest/daily_users.sql
}

function analytics_survey {
    ${YQL} -i analytics/survey/survey_stat.sql
}

function analytics_quality {
    ${YQL} -i analytics/rivals/rivals.sql
    ${YQL} -i analytics/checklist/problem_fixes.sql
}

function analytics_robot_jupiter_meta {
    analytics/robot/jupiter_meta.sh
}

function analytics_robot_wmc_11046 {
    transfer-manager add-task --sync \
        --src-cluster arnold --src-table //home/robot-metrics/spy_log_sbr/webmaster_samples/main_2_users \
        --dst-cluster hahn --dst-table //home/webmaster/prod/analytics/robot/pools/robot-metrics_spy_log_sbr_webmaster_samples_main_2_users

    ${YQL} -i analytics/robot/wmc-11046.sql
}

function analytics_robot_wmc_10758 {
    ${YQL} -i analytics/robot/wmc-10758.sql
}

function analytics_support_verification_fails {
    ${YQL} -i analytics/support/verification_fails.sql
}

function analytics_turbo_settings_history {
    ${YQL} -i analytics/turbo/settings_history.sql
}

function analytics_turbo_features_stat {
    ${YQL} -i analytics/turbo/features_stat.sql
}

function analytics_feeds_stats_transfer {
    transfer-manager add-task --sync \
            --src-cluster hahn --src-table //home/webmaster/prod/turbo/shops_teasers_domains_host2vec \
            --dst-cluster arnold --dst-table //home/webmaster/prod/turbo/shops_teasers_domains_host2vec
}

function analytics_feeds_stats_1 {
    ${YQL} -i analytics/feeds/wmc-11170-1.sql
}

function analytics_feeds_stats_2 {
    ${YQL} -i analytics/feeds/wmc-11170-2.sql
}

function analytics_feeds_stats_vertical_share {
    ${YQL} -i analytics/feeds/wmc-11484.sql
}

function analytics_feeds_stats {
    echo
}

function analytics_niche_universal_stats {
    ${YQL} -i analytics/niche/WMC-11389-universal-stats.sql
}

function analytics_niche_host2vec_stats {
    ${YQL} -i analytics/niche/WMC-11389-host2vec-stats.sql
}

function analytics_niche_visibility_stats {
    ${YQL} -i analytics/niche/WMC-11389-visibility-stats.sql
}

function analytics_niche_porn_stats {
    ${YQL} -i analytics/niche/WMC-11389-porn-stupids.sql
}

function analytics_niche_rivals {
    echo
}

function analytics_last_commercial_owners {
    ${YQL} -i analytics/b2b-top/last_commercial_owners.sql
}


function analytics_feeds {
    ${YQL} -i analytics/feeds/wmc-11591.sql
}

function analytics_feeds_sort {
    ${YQL} -i analytics/feeds/wmc-11591-sort.sql
}

function analytics_consumption_yt_operations {
    ${YQL} -i analytics/consumption_yt/consumption-yt-operation-stats.sql
}

function analytics_consumption_yt_tables {
    YT_PROXY=arnold.yt.yandex.net analytics/consumption_yt/consumption_yt
}
