use hahn;
pragma yt.ForceInferSchema;

$output_tail    = "//home/webmaster/prod/analytics/dev/commits.tail";
$output         = "//home/webmaster/prod/analytics/dev/commits";

$capture = Re2::Capture("(.+?)\\s+\\(.+\\)");
$format = DateTime::Format("%Y-%m-%d %H:%M:%S");
$convert = ($period) -> {
    return $format(DateTime::MakeDatetime(DateTime::ParseIso8601($capture($period)._1)))
};

insert into $output
    with truncate
select 
    Revision,
    some(coalesce($convert(Period), Period)) as Period,
    some(Login) as Login,
    some(Lines) as Lines,
from concat(
    $output_tail,
    $output
)
group by
    Revision
order by
    Revision
