use arnold;

/*
Доля визитов и визиторов Вебмастера и GSC относительно суммы этих двух сервисов
Отношение визитов и визиторов отдельно по Вебмастеру и GSC к общим визитам и визиторам SG
Абсолюты визитов и визиторов Вебмастера и GSC, абсолюты визитов и визиторов всего в SG

https://st.yandex-team.ru/WMC-5767#61cc936efe9fba1ae0b5616a
*/

insert into `//home/webmaster/prod/analytics/engagement/gsc_vs_ywm/report`
    with truncate
select 
    Period,

    VisitsYWM,
    VisitorsYWM,
    VisitsGSC,
    VisitorsGSC,
    VisitsTotal,
    VisitorsTotal,

    cast(VisitsYWM as float) / cast(VisitsYWM + VisitsGSC as float) as NormSumVisitsYWM,
    cast(VisitsGSC as float) / cast(VisitsYWM + VisitsGSC as float) as NormSumVisitsGSC,
    cast(VisitorsYWM as float) / cast(VisitorsYWM + VisitorsGSC as float) as NormSumVisitorsYWM,
    cast(VisitorsGSC as float) / cast(VisitorsYWM + VisitorsGSC as float) as NormSumVisitorsGSC,

    cast(VisitsYWM as float) / cast(VisitsTotal as float) as NormTotalVisitsYWM,
    cast(VisitsGSC as float) / cast(VisitsTotal as float) as NormTotalVisitsGSC,
    cast(VisitorsYWM as float) / cast(VisitorsTotal as float) as NormTotalVisitorsYWM,
    cast(VisitorsGSC as float) / cast(VisitorsTotal as float) as NormTotalVisitorsGSC,

from `//home/webmaster/prod/analytics/engagement/gsc_vs_ywm/stats`
order by Period;
