use arnold;
pragma yt.InferSchema="1";
-- pragma yt.AutoMerge="disabled";
-- pragma yt.Pool="robot-webmaster";

$GetDateFromTs = ($ts) -> {
    return cast(
        DateTime::MakeDate(
            DateTime::FromMilliseconds(cast($ts as Uint64))
        ) as String
    );
};

-- need: domain, feed_url, region_id, enabled, type_wm, scc_status_wm

$joined_version = (
    select $GetDateFromTs(COALESCE(a.add_date, b.add_date)) as `date`, COALESCE(a.domain, b.domain) as domain, COALESCE(a.feed_url, b.feed_url) as feed_url, COALESCE(a.region_id, b.region_id) as region_id, COALESCE(a.enabled, b.enabled) as enabled, COALESCE(a.type_wm, b.type_wm) as type_wm, COALESCE(a.scc_status_wm, b.scc_status_wm) as scc_status_wm 
    from `//home/webmaster/prod/export/feeds/unisearch/offer_feeds_moderation` as a
    full join `//home/webmaster/prod/export/feeds/unisearch/offer_feeds` as b
    on a.domain == b.domain and a.feed_url == b.feed_url and a.region_id == b.region_id
);

-- get info for pairs (type_wm, scc_status_wm)
-- type_wm : CARS, EDUCATION, REALTY, SERVICES, STORES, VACANCY
-- scc_status_wm : BANNED, FAILED, IN_PROGRESS, SUCCES
$table = 
select `date`, 
        count(*) as all_uploaded,
        count_if(enabled) as all_enabled,

        -- count_if(type_wm == "CARS") as `cars_uploaded`,
        -- count_if(type_wm == "CARS" and enabled) as `cars_enabled`,
        -- count_if(type_wm == "EDUCATION") as `education_uploaded`,
        -- count_if(type_wm == "EDUCATION" and enabled) as `education_enabled`,
        -- count_if(type_wm == "REALTY") as `realty_uploaded`,
        -- count_if(type_wm == "REALTY" and enabled) as `realty_enabled`,
        -- count_if(type_wm == "SERVICES") as `services_uploaded`,
        -- count_if(type_wm == "SERVICES" and enabled) as `services_enabled`,
        -- count_if(type_wm == "STORES") as `stores_uploaded`,
        -- count_if(type_wm == "STORES" and enabled) as `stores_enabled`,
        -- count_if(type_wm == "VACANCY") as `vacancy_uploaded`,
        -- count_if(type_wm == "VACANCY" and enabled) as `vacancy_enabled`,

        -- count_if(scc_status_wm == "BANNED") as `banned_uploaded`,
        -- count_if(scc_status_wm == "BANNED" and enabled) as `banned_enabled`,
        -- count_if(scc_status_wm == "FAILED") as `failed_uploaded`,
        -- count_if(scc_status_wm == "FAILED" and enabled) as `failed_enabled`,
        -- count_if(scc_status_wm == "IN_PROGRESS") as `in_progress_uploaded`,
        -- count_if(scc_status_wm == "IN_PROGRESS" and enabled) as `in_progress_enabled`,
        count_if(scc_status_wm == "SUCCESS") as `success_uploaded`,
        count_if(scc_status_wm == "SUCCESS" and enabled) as `success_enabled`,

        -- count_if(type_wm == "CARS" and scc_status_wm == "BANNED") as `cars_banned_uploaded`,
        -- count_if(type_wm == "CARS" and scc_status_wm == "BANNED" and enabled) as `cars_banned_enabled`,
        -- count_if(type_wm == "CARS" and scc_status_wm == "FAILED") as `cars_failed_uploaded`,
        -- count_if(type_wm == "CARS" and scc_status_wm == "FAILED" and enabled) as `cars_failed_enabled`,
        -- count_if(type_wm == "CARS" and scc_status_wm == "IN_PROGRESS") as `cars_in_progress_uploaded`,
        -- count_if(type_wm == "CARS" and scc_status_wm == "IN_PROGRESS" and enabled) as `cars_in_progress_enabled`,
        -- count_if(type_wm == "CARS" and scc_status_wm == "SUCCESS") as `cars_success_uploaded`,
        -- count_if(type_wm == "CARS" and scc_status_wm == "SUCCESS" and enabled) as `cars_success_enabled`,

        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "BANNED") as `education_banned_uploaded`,
        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "BANNED" and enabled) as `education_banned_enabled`,
        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "FAILED") as `education_failed_uploaded`,
        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "FAILED" and enabled) as `education_failed_enabled`,
        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "IN_PROGRESS") as `education_in_progress_uploaded`,
        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "IN_PROGRESS" and enabled) as `education_in_progress_enabled`,
        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "SUCCESS") as `education_success_uploaded`,
        -- count_if(type_wm == "EDUCATION" and scc_status_wm == "SUCCESS" and enabled) as `education_success_enabled`,

        -- count_if(type_wm == "REALTY" and scc_status_wm == "BANNED") as `realty_banned_uploaded`,
        -- count_if(type_wm == "REALTY" and scc_status_wm == "BANNED" and enabled) as `realty_banned_enabled`,
        -- count_if(type_wm == "REALTY" and scc_status_wm == "FAILED") as `realty_failed_uploaded`,
        -- count_if(type_wm == "REALTY" and scc_status_wm == "FAILED" and enabled) as `realty_failed_enabled`,
        -- count_if(type_wm == "REALTY" and scc_status_wm == "IN_PROGRESS") as `realty_in_progress_uploaded`,
        -- count_if(type_wm == "REALTY" and scc_status_wm == "IN_PROGRESS" and enabled) as `realty_in_progress_enabled`,
        -- count_if(type_wm == "REALTY" and scc_status_wm == "SUCCESS") as `realty_success_uploaded`,
        -- count_if(type_wm == "REALTY" and scc_status_wm == "SUCCESS" and enabled) as `realty_success_enabled`,

        -- count_if(type_wm == "SERVICES" and scc_status_wm == "BANNED") as `services_banned_uploaded`,
        -- count_if(type_wm == "SERVICES" and scc_status_wm == "BANNED" and enabled) as `services_banned_enabled`,
        -- count_if(type_wm == "SERVICES" and scc_status_wm == "FAILED") as `services_failed_uploaded`,
        -- count_if(type_wm == "SERVICES" and scc_status_wm == "FAILED" and enabled) as `services_failed_enabled`,
        -- count_if(type_wm == "SERVICES" and scc_status_wm == "IN_PROGRESS") as `services_in_progress_uploaded`,
        -- count_if(type_wm == "SERVICES" and scc_status_wm == "IN_PROGRESS" and enabled) as `services_in_progress_enabled`,
        -- count_if(type_wm == "SERVICES" and scc_status_wm == "SUCCESS") as `services_success_uploaded`,
        -- count_if(type_wm == "SERVICES" and scc_status_wm == "SUCCESS" and enabled) as `services_success_enabled`,

        -- count_if(type_wm == "STORES" and scc_status_wm == "BANNED") as `stores_banned_uploaded`,
        -- count_if(type_wm == "STORES" and scc_status_wm == "BANNED" and enabled) as `stores_banned_enabled`,
        -- count_if(type_wm == "STORES" and scc_status_wm == "FAILED") as `stores_failed_uploaded`,
        -- count_if(type_wm == "STORES" and scc_status_wm == "FAILED" and enabled) as `stores_failed_enabled`,
        -- count_if(type_wm == "STORES" and scc_status_wm == "IN_PROGRESS") as `stores_in_progress_uploaded`,
        -- count_if(type_wm == "STORES" and scc_status_wm == "IN_PROGRESS" and enabled) as `stores_in_progress_enabled`,
        -- count_if(type_wm == "STORES" and scc_status_wm == "SUCCESS") as `stores_success_uploaded`,
        -- count_if(type_wm == "STORES" and scc_status_wm == "SUCCESS" and enabled) as `stores_success_enabled`,

        -- count_if(type_wm == "VACANCY" and scc_status_wm == "BANNED") as `vacancy_banned_uploaded`,
        -- count_if(type_wm == "VACANCY" and scc_status_wm == "BANNED" and enabled) as `vacancy_banned_enabled`,
        -- count_if(type_wm == "VACANCY" and scc_status_wm == "FAILED") as `vacancy_failed_uploaded`,
        -- count_if(type_wm == "VACANCY" and scc_status_wm == "FAILED" and enabled) as `vacancy_failed_enabled`,
        -- count_if(type_wm == "VACANCY" and scc_status_wm == "IN_PROGRESS") as `vacancy_in_progress_uploaded`,
        -- count_if(type_wm == "VACANCY" and scc_status_wm == "IN_PROGRESS" and enabled) as `vacancy_in_progress_enabled`,
        -- count_if(type_wm == "VACANCY" and scc_status_wm == "SUCCESS") as `vacancy_success_uploaded`,
        -- count_if(type_wm == "VACANCY" and scc_status_wm == "SUCCESS" and enabled) as `vacancy_success_enabled`,

from $joined_version
group by `date`;

insert into `//home/webmaster/prod/analytics/feeds/uploads_and_enables_with_cumsum` with truncate
select 
    `date`,
    sum(all_uploaded) over (order by `date` rows between unbounded preceding and current row) as all_uploaded,
    sum(all_enabled) over (order by `date` rows between unbounded preceding and current row) as all_enabled,
    sum(success_uploaded) over (order by `date` rows between unbounded preceding and current row) as success_uploaded,
    sum(success_enabled) over (order by `date` rows between unbounded preceding and current row) as success_enabled,

from $table
order by `date`
;

insert into `//home/webmaster/prod/analytics/feeds/uploads_and_enables` with truncate
select 
    *
from $table
order by `date`
;



