pragma yt.InferSchema="1";
-- pragma yt.AutoMerge="disabled";
-- pragma yt.Pool="robot-webmaster";

use arnold;

$shop_list = (
    select distinct Analogy as domain
    from `//home/webmaster/prod/turbo/shops_teasers_domains_host2vec`
    group by Analogy
);

$GetDateFromTs = ($ts) -> {
    return cast(
        DateTime::MakeDate(
            DateTime::FromMilliseconds(cast($ts as Uint64))
        ) as String
    );
};

-- need: domain, feed_url, region_id, enabled, type_wm, scc_status_wm
    
$joined_version = (
    select $GetDateFromTs(COALESCE(a.add_date, b.add_date)) as `date`, COALESCE(a.domain, b.domain) as domain, COALESCE(a.feed_url, b.feed_url) as feed_url, COALESCE(a.region_id, b.region_id) as region_id, COALESCE(a.enabled, b.enabled) as enabled, COALESCE(a.type_wm, b.type_wm) as type_wm, COALESCE(a.scc_status_wm, b.scc_status_wm) as scc_status_wm 
    from `//home/webmaster/prod/export/feeds/unisearch/offer_feeds_moderation` as a
    full join `//home/webmaster/prod/export/feeds/unisearch/offer_feeds` as b
    on a.domain == b.domain and a.feed_url == b.feed_url and a.region_id == b.region_id
);

$three_month_ago = DateTime::MakeDate(DateTime::ShiftMonths(CurrentUtcDate(), -3));


$active_shop_list = 
(
    select distinct b.domain as domain
    from 
    (
        select *
        from `//home/webmaster/prod/analytics/logs/webmaster-visits`
        where DateTime::MakeDate(DateTime::Parse("%Y-%m-%d")(Period)) > $three_month_ago
    ) as a
    join  $shop_list as b
    on b.domain == Url::GetDomain(a.Host, 2)
)
;

$table = 
select 
    a.`date` as `date`,  
    a.feed_active_size as feed_active_size,
    total_active_size,
    total_size
from
(
    select a.`date` as `date`, count(*) as feed_active_size
    from $joined_version as a
    inner join $shop_list as b 
    on a.domain == b.domain
    group by a.`date` 
) as a
cross join 
( select a.total_size as total_size, b.total_active_size as total_active_size
from  
(
    select count(*) as total_size
    from $shop_list
) as a
cross join 
(
    select count(*) as total_active_size
    from $active_shop_list
) as b
) as b
;

insert into `//home/webmaster/prod/analytics/feeds/shops_stats` with truncate
select `date`,
sum(feed_active_size) over (order by `date` rows between unbounded preceding and current row) as feed_active_size,
total_active_size,
total_size
from $table
order by `date`;