use hahn;
pragma yt.InferSchema="1";
-- pragma yt.AutoMerge="disabled";
-- pragma yt.Pool="robot-webmaster";

$makePivot = ($nameColumn, $valueColumn, $nameList) -> {
    RETURN EvaluateCode(LambdaCode(($row) -> {
        $name = FuncCode("Member", $row, AtomCode($nameColumn));
        $value = FuncCode("Member", $row, AtomCode($valueColumn));
        $row = FuncCode("RemoveMember", $row, AtomCode($nameColumn));
        $row = FuncCode("RemoveMember", $row, AtomCode($valueColumn));

        $ensureOptional = ($x) -> {
            RETURN YQL::MatchType($x, AsAtom("Optional"), () -> { RETURN $x }, () -> { RETURN Just($x) });
        };

        $structItems = ListMap($nameList, ($item) -> {
            $adjustedValue = FuncCode("Apply", QuoteCode($ensureOptional), $value);
            $ifValue = FuncCode("FlatOptionalIf",
                FuncCode("Coalesce", FuncCode("==", $name, ReprCode($item)), ReprCode(false)),
                $adjustedValue);
            RETURN ListCode(AtomCode($item), $ifValue);
        });

        $struct = FuncCode("AsStruct", $structItems);
        RETURN FuncCode("AddMember", $row, AtomCode($valueColumn), $struct);
    }));
};
$pivot =  $makePivot("type", "cnt", AsList("cars", "doctors", "goods", "education", "realty",
"services", "vacancies", "cars_success", "doctors_success", "goods_success", "education_success",
"realty_success", "services_success", "vacancies_success"));

$GetDateFromTs = ($ts) -> {
    return cast(
        DateTime::MakeDate(
            DateTime::FromMilliseconds(cast($ts as Uint64))
        ) as String
    );
};


$GetDateFromTs2 = ($ts) -> {
    return DateTime::MakeDatetime(DateTime::Parse("%Y-%m-%d")($ts))
};

-- need: domain, feed_url, region_id, enabled, type_wm, scc_status_wm

$feed = (
    select `date` as date_time, type, count(*) as cnt from (
    select $GetDateFromTs(add_date) as `date`, type
    from Concat(`home/webmaster/prod/export/feeds/unisearch/offer_feeds_moderation`,
                            `home/webmaster/prod/export/feeds/unisearch/offer_feeds`)
    )                       group by `date`, type


);



$success_feed = (
    select `date` as date_time, type, count(*) as cnt from (
    select $GetDateFromTs(add_date) as `date`, (type || "_success") as type
    from Concat(`home/webmaster/prod/export/feeds/unisearch/offer_feeds_moderation`,
                            `home/webmaster/prod/export/feeds/unisearch/offer_feeds`)
                            where scc_status_wm ='SUCCESS'
    )                       group by `date`, type


);

$x = select * from $feed union all select * from $success_feed;



$table = SELECT * FROM (
                           SELECT
                               AsStruct(date_time as `date_time`),

                               MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                           FROM (
                                    SELECT * FROM (
                                                      SELECT $pivot(TableRow()) FROM $x
                                                  ) FLATTEN COLUMNS
                                ) GROUP BY date_time
                       ) FLATTEN COLUMNS;


INSERT INTO `//home/webmaster/prod/analytics/feeds/feeds_by_type_history`
select  $GetDateFromTs2(date_time) as date_time,
        sum(nvl(cars, 0)) over (order by date_time rows between unbounded preceding and current row) as cars,
        sum(nvl(cars_success, 0)) over (order by date_time rows between unbounded preceding and current row) as cars_success,
        sum(nvl(doctors, 0)) over (order by date_time rows between unbounded preceding and current row) as doctors,
        sum(nvl(doctors_success, 0)) over (order by date_time rows between unbounded preceding and current row) as doctors_success,
        sum(nvl(goods, 0)) over (order by date_time rows between unbounded preceding and current row) as goods,
        sum(nvl(goods_success, 0)) over (order by date_time rows between unbounded preceding and current row) as goods_success,
        sum(nvl(education, 0)) over (order by date_time rows between unbounded preceding and current row) as education,
        sum(nvl(education_success, 0)) over (order by date_time rows between unbounded preceding and current row) as education_success,
        sum(nvl(realty, 0)) over (order by date_time rows between unbounded preceding and current row) as realty,
        sum(nvl(realty_success, 0)) over (order by date_time rows between unbounded preceding and current row) as realty_success,
        sum(nvl(services, 0)) over (order by date_time rows between unbounded preceding and current row) as services,
        sum(nvl(services_success, 0)) over (order by date_time rows between unbounded preceding and current row) as services_success,
        sum(nvl(vacancies, 0)) over (order by date_time rows between unbounded preceding and current row) as vacancies,
        sum(nvl(vacancies_success, 0)) over (order by date_time rows between unbounded preceding and current row) as vacancies_success
from $table
order by `date_time`;