use hahn;

$curDate = CurrentUtcDatetime();
$ttl = 60 * 60 * 24 * 15;

$makePivot = ($nameColumn, $valueColumn, $nameList) -> {
    RETURN EvaluateCode(LambdaCode(($row) -> {
        $name = FuncCode("Member", $row, AtomCode($nameColumn));
        $value = FuncCode("Member", $row, AtomCode($valueColumn));
        $row = FuncCode("RemoveMember", $row, AtomCode($nameColumn));
        $row = FuncCode("RemoveMember", $row, AtomCode($valueColumn));

        $ensureOptional = ($x) -> {
            RETURN YQL::MatchType($x, AsAtom("Optional"), () -> { RETURN $x }, () -> { RETURN Just($x) });
        };

        $structItems = ListMap($nameList, ($item) -> {
            $adjustedValue = FuncCode("Apply", QuoteCode($ensureOptional), $value);
            $ifValue = FuncCode("FlatOptionalIf",
                FuncCode("Coalesce", FuncCode("==", $name, ReprCode($item)), ReprCode(false)),
                $adjustedValue);
            RETURN ListCode(AtomCode($item), $ifValue);
        });

        $struct = FuncCode("AsStruct", $structItems);
        RETURN FuncCode("AddMember", $row, AtomCode($valueColumn), $struct);
    }));
};
$pivot =  $makePivot("type", "cnt", AsList("cars", "doctors", "goods", "education", "realty",
"services", "vacancies", "geoorg", "cars_success", "doctors_success", "goods_success", "education_success",
"realty_success", "services_success", "vacancies_success", "geoorg_success"));

$new_offer_feeds = select * from Concat(`home/webmaster/prod/export/feeds/unisearch/offer_feeds_moderation`,
                                        `home/webmaster/prod/export/feeds/unisearch/offer_feeds`);
$old_offer_feeds = select * from `//home/webmaster/prod/analytics/feeds/old_offer_feeds`;

-- feeds by type statistics

$feeds_by_type = SELECT type, count(*) as cnt
FROM $new_offer_feeds
group by type;

$success_feeds_by_type = SELECT type, count(*) as cnt
FROM $new_offer_feeds
where scc_status_wm='SUCCESS'
group by (type || "_success") as type;

$feeds_stats = select * from $feeds_by_type union all select * from $success_feeds_by_type;


$feeds_by_type_result = SELECT * FROM (
                  SELECT
                      MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                  FROM (
                      SELECT * FROM (
                            SELECT $pivot(TableRow()) FROM $feeds_stats
                            ) FLATTEN COLUMNS
                  )
              ) FLATTEN COLUMNS;

insert into `//home/webmaster/prod/analytics/feeds/feeds_by_type_history` with truncate
select * from `//home/webmaster/prod/analytics/feeds/feeds_by_type_history`
UNION ALL
select $curDate as date_time, a.* from $feeds_by_type_result as a;


-- owner by type statistics


$owners_by_type = SELECT type, count(DISTINCT Url::GetOwner(domain)) as cnt
                      FROM $new_offer_feeds
                      group by type;

$success_owners_by_type = SELECT type, count(DISTINCT Url::GetOwner(domain)) as cnt
                          FROM $new_offer_feeds
                          where scc_status_wm='SUCCESS'
                          group by (type || "_success") as type;

$owners_stats = select * from $owners_by_type union all select * from $success_owners_by_type;


$owners_by_type_result = SELECT * FROM (
                  SELECT
                      MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                  FROM (
                      SELECT * FROM (
                            SELECT $pivot(TableRow()) FROM $owners_stats
                            ) FLATTEN COLUMNS
                  )
              ) FLATTEN COLUMNS;

insert into `//home/webmaster/prod/analytics/feeds/owners_by_type_history` with truncate
select * from `//home/webmaster/prod/analytics/feeds/owners_by_type_history`
UNION ALL
select $curDate as date_time, a.* from $owners_by_type_result as a;

-- increase_decrease_feeds
$pivot2 =  $makePivot("type", "cnt", AsList(
"cars_add", "doctors_add", "goods_add", "education_add", "realty_add", "services_add", "vacancies_add", "geoorg_add",
"cars_delete", "doctors_delete", "goods_delete", "education_delete", "realty_delete", "services_delete", "vacancies_delete",
    "geoorg_delete"
));

$add_feeds_by_type = SELECT type, count(*) as cnt
                 FROM $new_offer_feeds as new_f left join $old_offer_feeds as old_f
                 on new_f.domain=old_f.domain and new_f.feed_url=old_f.feed_url
                 where old_f.domain is null
                 group by (new_f.type || "_add") as type;



$delete_feeds_by_type = SELECT type, count(*) as cnt
                 FROM $new_offer_feeds as new_f right join $old_offer_feeds as old_f
                 on new_f.domain=old_f.domain and new_f.feed_url=old_f.feed_url
                 where new_f.domain is null
                 group by (old_f.type || "_delete") as type;

$changes = select * from $add_feeds_by_type union all select * from $delete_feeds_by_type;


$changes_by_type_result = SELECT * FROM (
                  SELECT
                      MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                  FROM (
                      SELECT * FROM (
                            SELECT $pivot2(TableRow()) FROM $changes
                            ) FLATTEN COLUMNS
                  )
              ) FLATTEN COLUMNS;


insert into `//home/webmaster/prod/analytics/feeds/changes_by_type_history` with truncate
select
date_time,
nvl(cars_add, 0) as cars_add,
nvl(cars_delete, 0) as cars_delete,
nvl(doctors_add, 0) as doctors_add,
nvl(doctors_delete, 0) as doctors_delete,
nvl(goods_add, 0) as goods_add,
nvl(goods_delete, 0) as goods_delete,
nvl(realty_add, 0) as realty_add,
nvl(realty_delete, 0) as realty_delete,
nvl(education_add, 0) as education_add,
nvl(education_delete, 0) as education_delete,
nvl(services_add, 0) as services_add,
nvl(services_delete, 0) as services_delete,
nvl(vacancies_add, 0) as vacancies_add,
nvl(vacancies_delete, 0) as vacancies_delete,
nvl(geoorg_add, 0) as geoorg_add,
nvl(geoorg_delete, 0) as geoorg_delete,
FROM
(select * from `//home/webmaster/prod/analytics/feeds/changes_by_type_history`
UNION ALL
select $curDate as date_time, a.* from $changes_by_type_result as a);

-- a

$new_offer_feeds_uniq = select distinct domain, feed_url, type, scc_status_wm from Concat(`home/webmaster/prod/export/feeds/unisearch/offer_feeds_moderation`,
    `home/webmaster/prod/export/feeds/unisearch/offer_feeds`);
$old_offer_feeds_uniq = select distinct domain, feed_url, type, scc_status_wm from `//home/webmaster/prod/analytics/feeds/old_offer_feeds`;

-- without counting each region_id as uniq feed

$add_feeds_by_type_uniq = SELECT type, count(*) as cnt
                          FROM $new_offer_feeds_uniq as new_f left join $old_offer_feeds_uniq as old_f
                                on new_f.domain=old_f.domain and new_f.feed_url=old_f.feed_url
                          where old_f.domain is null
                          group by (new_f.type || "_add") as type;



$delete_feeds_by_type_uniq = SELECT type, count(*) as cnt
                             FROM $new_offer_feeds_uniq as new_f right join $old_offer_feeds_uniq as old_f
                                on new_f.domain=old_f.domain and new_f.feed_url=old_f.feed_url
                             where new_f.domain is null
                             group by (old_f.type || "_delete") as type;

$changes_uniq = select * from $add_feeds_by_type_uniq union all select * from $delete_feeds_by_type_uniq;


$changes_by_type_result_uniq = SELECT * FROM (
                 SELECT
                     MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                 FROM (
                          SELECT * FROM (
                                            SELECT $pivot2(TableRow()) FROM $changes_uniq
                                        ) FLATTEN COLUMNS
                      )
             ) FLATTEN COLUMNS;


insert into `//home/webmaster/prod/analytics/feeds/changes_by_type_history_uniq` with truncate
                  select
                      date_time,
                      nvl(cars_add, 0) as cars_add,
                      nvl(cars_delete, 0) as cars_delete,
                      nvl(doctors_add, 0) as doctors_add,
                      nvl(doctors_delete, 0) as doctors_delete,
                      nvl(goods_add, 0) as goods_add,
                      nvl(goods_delete, 0) as goods_delete,
                      nvl(realty_add, 0) as realty_add,
                      nvl(realty_delete, 0) as realty_delete,
                      nvl(education_add, 0) as education_add,
                      nvl(education_delete, 0) as education_delete,
                      nvl(services_add, 0) as services_add,
                      nvl(services_delete, 0) as services_delete,
                      nvl(vacancies_add, 0) as vacancies_add,
                      nvl(vacancies_delete, 0) as vacancies_delete,
                      nvl(geoorg_add, 0) as geoorg_add,
                      nvl(geoorg_delete, 0) as geoorg_delete,
                  FROM
                      (select * from `//home/webmaster/prod/analytics/feeds/changes_by_type_history_uniq`
                       UNION ALL
                       select $curDate as date_time, a.* from $changes_by_type_result_uniq as a);



-- feeds by type statistics without counting each region_id as uniq feed

$feeds_by_type_uniq = SELECT type, count(*) as cnt
                      FROM $new_offer_feeds_uniq
                      group by type;

$success_feeds_by_type_uniq = SELECT type, count(*) as cnt
                              FROM $new_offer_feeds_uniq
                              where scc_status_wm='SUCCESS'
                              group by (type || "_success") as type;

$feeds_stats_uniq = select * from $feeds_by_type_uniq union all select * from $success_feeds_by_type_uniq;


$feeds_by_type_result_uniq = SELECT * FROM (
               SELECT
                   MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
               FROM (
                        SELECT * FROM (
                                          SELECT $pivot(TableRow()) FROM $feeds_stats_uniq
                                      ) FLATTEN COLUMNS
                    )
           ) FLATTEN COLUMNS;

insert into `//home/webmaster/prod/analytics/feeds/feeds_by_type_history_uniq` with truncate
        select * from `//home/webmaster/prod/analytics/feeds/feeds_by_type_history_uniq`
        UNION ALL
        select $curDate as date_time, a.* from $feeds_by_type_result_uniq as a;

--//////////////////
$pivot3 =  $makePivot("type", "cnt", AsList("cars", "doctors", "goods", "education", "realty",
"services", "vacancies", "geoorg",
"cars_success", "doctors_success", "goods_success", "education_success",
"realty_success", "services_success", "vacancies_success", "geoorg_success",
"cars_banned", "doctors_banned", "goods_banned", "education_banned",
"realty_banned", "services_banned", "vacancies_banned", "geoorg_banned",
"cars_bad_one", "doctors_bad_one", "goods_bad_one", "education_bad_one",
"realty_bad_one", "services_bad_one", "vacancies_bad_one", "geoorg_bad_one",
"cars_bad_all", "doctors_bad_all", "goods_bad_all", "education_bad_all",
"realty_bad_all", "services_bad_all", "vacancies_bad_all", "geoorg_bad_all"
));


$new_offer_feeds_ow = select distinct Url::GetOwner(domain) as owner, feed_url, type, scc_status_wm from $new_offer_feeds;
$old_offer_feeds_ow = select distinct Url::GetOwner(domain) as owner, feed_url, type, scc_status_wm from $old_offer_feeds;

$banned_owners =
SELECT owner, type FROM $new_offer_feeds_ow
group by owner, type
having count(distinct scc_status_wm)=1 and some(scc_status_wm)='BANNED';

$banned_owners_by_type = SELECT type, count(distinct owner) as cnt
                         FROM $banned_owners
                         group by (type || "_banned") as type;



$failed_almost_one_failed_feed_by_owners =
SELECT owner, type
FROM $new_offer_feeds_ow
group by owner, type
having count_if(scc_status_wm in
                ('FAILED', 'DISABLED_BY_PINGER', 'BANNED'))>=1;

$failed_almost_one_failed_feed_by_owners_by_type = SELECT type, count(distinct owner) as cnt
                                                   FROM $failed_almost_one_failed_feed_by_owners
                                                   group by (type || "_bad_one") as type;


$failed_all__failed_feed_by_owner =
SELECT owner, type
FROM $new_offer_feeds_ow
group by owner, type
having count_if(scc_status_wm in ('FAILED', 'DISABLED_BY_PINGER'))>=1
   and count_if(scc_status_wm in ('FAILED', 'DISABLED_BY_PINGER', 'BANNED')) = count(scc_status_wm);

$failed_all__failed_feed_by_owner_by_type = SELECT type, count(distinct owner) as cnt
                                            FROM $failed_all__failed_feed_by_owner
                                            group by (type || "_bad_all") as type;

$owners_stats_scc = select * from $owners_by_type
                    union all select * from $success_owners_by_type
                    union all select * from $banned_owners_by_type
                    union all select * from $failed_almost_one_failed_feed_by_owners_by_type
                    union all select * from $failed_all__failed_feed_by_owner_by_type;


$owners_statuses_with_extra_statuses =
SELECT * FROM (
                  SELECT
                      MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                  FROM (
                           SELECT * FROM (
                                             SELECT $pivot3(TableRow()) FROM $owners_stats_scc
                                         ) FLATTEN COLUMNS
                       )
              ) FLATTEN COLUMNS;

insert into `//home/webmaster/prod/analytics/feeds/owners_by_type_history_extra` with truncate
                select * from `//home/webmaster/prod/analytics/feeds/owners_by_type_history_extra`
                UNION ALL
                select $curDate as date_time, a.* from $owners_statuses_with_extra_statuses as a;
-- changes owners


$owners = SELECT DISTINCT owner, type FROM $new_offer_feeds_ow;

$owners_old = SELECT DISTINCT owner, type FROM $old_offer_feeds_ow;

$success_owners = SELECT DISTINCT type, owner
                  FROM $new_offer_feeds_ow
                  where scc_status_wm='SUCCESS';

$success_owners_old = SELECT DISTINCT type, owner
                      FROM $old_offer_feeds_ow
                      where scc_status_wm='SUCCESS';

$banned_owners_old =
SELECT owner, type FROM $old_offer_feeds_ow
group by owner, type
having count(distinct scc_status_wm)=1 and some(scc_status_wm)='BANNED';


$add_owner_by_type = SELECT type, count(distinct new_f.owner) as cnt
                     FROM $owners as new_f left join $owners_old as old_f
                                                     on new_f.owner=old_f.owner
                     where old_f.owner is null
                     group by (new_f.type || "_add") as type;

$delete_owner_by_type = SELECT type, count(distinct old_f.owner) as cnt
                        FROM $owners as new_f right join $owners_old as old_f
                                                         on new_f.owner=old_f.owner
                        where new_f.owner is null
                        group by (old_f.type || "_delete") as type;

$changes_owners = select * from $add_owner_by_type union all select * from $delete_owner_by_type;


$add_success_owner_by_type = SELECT type, count(*) as cnt
                             FROM $success_owners as new_f left join $success_owners_old as old_f
                                                                     on new_f.owner=old_f.owner
                             where old_f.owner is null
                             group by (new_f.type || "_add") as type;

$delete_success_owner_by_type = SELECT type, count(*) as cnt
                                FROM $success_owners as new_f right join $success_owners_old as old_f
                                                                         on new_f.owner=old_f.owner
                                where new_f.owner is null
                                group by (old_f.type || "_delete") as type;

$changes_success_owners = select * from $add_success_owner_by_type union all select * from $delete_success_owner_by_type;


$add_banned_owner_by_type = SELECT type, count(*) as cnt
                            FROM $banned_owners as new_f left join $banned_owners_old as old_f
                                                                   on new_f.owner=old_f.owner
                            where old_f.owner is null
                            group by (new_f.type || "_add") as type;

$delete_banned_owner_by_type = SELECT type, count(*) as cnt
                               FROM $banned_owners as new_f right join $banned_owners_old as old_f
                                                                       on new_f.owner=old_f.owner
                               where new_f.owner is null
                               group by (old_f.type || "_delete") as type;

$changes_banned_owners = select * from $add_banned_owner_by_type union all select * from $delete_banned_owner_by_type;

$changes_banned_owners_by_type_result =
SELECT * FROM (
                  SELECT
                      MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                  FROM (
                           SELECT * FROM (
                                             SELECT $pivot2(TableRow()) FROM $changes_banned_owners
                                         ) FLATTEN COLUMNS
                       )
              ) FLATTEN COLUMNS;
$changes_owners_by_type_result =
SELECT * FROM (
                  SELECT
                      MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                  FROM (
                           SELECT * FROM (
                                             SELECT $pivot2(TableRow()) FROM $changes_owners
                                         ) FLATTEN COLUMNS
                       )
              ) FLATTEN COLUMNS;
$changes_success_owners_by_type_result =
SELECT * FROM (
      SELECT
          MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
      FROM (
               SELECT * FROM (
                                 SELECT $pivot2(TableRow()) FROM $changes_success_owners
                             ) FLATTEN COLUMNS
                       )
              ) FLATTEN COLUMNS;


insert into `//home/webmaster/prod/analytics/feeds/changes_owners_by_type_history` with truncate
            select
                date_time,
                nvl(cars_add, 0) as cars_add,
                nvl(cars_delete, 0) as cars_delete,
                nvl(doctors_add, 0) as doctors_add,
                nvl(doctors_delete, 0) as doctors_delete,
                nvl(goods_add, 0) as goods_add,
                nvl(goods_delete, 0) as goods_delete,
                nvl(realty_add, 0) as realty_add,
                nvl(realty_delete, 0) as realty_delete,
                nvl(education_add, 0) as education_add,
                nvl(education_delete, 0) as education_delete,
                nvl(services_add, 0) as services_add,
                nvl(services_delete, 0) as services_delete,
                nvl(vacancies_add, 0) as vacancies_add,
                nvl(vacancies_delete, 0) as vacancies_delete,
                nvl(geoorg_add, 0) as geoorg_add,
                nvl(geoorg_delete, 0) as geoorg_delete,
            FROM
                (select * from `//home/webmaster/prod/analytics/feeds/changes_owners_by_type_history`
                 UNION ALL
                 select $curDate as date_time, a.* from $changes_owners_by_type_result as a);

insert into `//home/webmaster/prod/analytics/feeds/changes_success_owners_by_type_history` with truncate
            select
                date_time,
                nvl(cars_add, 0) as cars_add,
                nvl(cars_delete, 0) as cars_delete,
                nvl(doctors_add, 0) as doctors_add,
                nvl(doctors_delete, 0) as doctors_delete,
                nvl(goods_add, 0) as goods_add,
                nvl(goods_delete, 0) as goods_delete,
                nvl(realty_add, 0) as realty_add,
                nvl(realty_delete, 0) as realty_delete,
                nvl(education_add, 0) as education_add,
                nvl(education_delete, 0) as education_delete,
                nvl(services_add, 0) as services_add,
                nvl(services_delete, 0) as services_delete,
                nvl(vacancies_add, 0) as vacancies_add,
                nvl(vacancies_delete, 0) as vacancies_delete,
                nvl(geoorg_add, 0) as geoorg_add,
                nvl(geoorg_delete, 0) as geoorg_delete,
            FROM
                (select * from `//home/webmaster/prod/analytics/feeds/changes_success_owners_by_type_history`
                 UNION ALL
                 select $curDate as date_time, a.* from $changes_success_owners_by_type_result as a);

insert into `//home/webmaster/prod/analytics/feeds/changes_banned_owners_by_type_history` with truncate
           select
               date_time,
               nvl(cars_add, 0) as cars_add,
               nvl(cars_delete, 0) as cars_delete,
               nvl(doctors_add, 0) as doctors_add,
               nvl(doctors_delete, 0) as doctors_delete,
               nvl(goods_add, 0) as goods_add,
               nvl(goods_delete, 0) as goods_delete,
               nvl(realty_add, 0) as realty_add,
               nvl(realty_delete, 0) as realty_delete,
               nvl(education_add, 0) as education_add,
               nvl(education_delete, 0) as education_delete,
               nvl(services_add, 0) as services_add,
               nvl(services_delete, 0) as services_delete,
               nvl(vacancies_add, 0) as vacancies_add,
               nvl(vacancies_delete, 0) as vacancies_delete,
               nvl(geoorg_add, 0) as geoorg_add,
               nvl(geoorg_delete, 0) as geoorg_delete,
           FROM
               (select * from `//home/webmaster/prod/analytics/feeds/changes_banned_owners_by_type_history`
                UNION ALL
                select $curDate as date_time, a.* from $changes_banned_owners_by_type_result as a);

-- diff

$pivot4 =  $makePivot("type", "cnt", AsList(
    "cars_success", "doctors_success", "goods_success", "education_success",
"realty_success", "services_success", "vacancies_success", "geoorg_success",
    "cars_failed", "doctors_failed", "goods_failed", "education_failed",
"realty_failed", "services_failed", "vacancies_failed", "geoorg_failed",
    "cars_banned", "doctors_banned", "goods_banned", "education_banned",
"realty_banned", "services_banned", "vacancies_banned", "geoorg_banned",
    "cars_deleted", "doctors_deleted", "goods_deleted", "education_deleted",
"realty_deleted", "services_deleted", "vacancies_deleted", "geoorg_deleted",
    ));

$added_owners_folder_path = "//home/webmaster/prod/analytics/feeds/added_owners";
$added_owners_path =
    $added_owners_folder_path || '/' || cast(DateTime::ToSeconds($curDate) as String) ;

$src_dt = (
    select aggregate_list(Period)
    from (
        select TableName(Path, "yt") as Period
        from folder($added_owners_folder_path)
        where Type == "table"
        order by Period desc
        limit 100
    )
);

define action $process_table($dt) as
    $src_table = $added_owners_folder_path || '/' || $dt;

$success_ow_by_type = select type || "_success" as type, count(owner) as cnt from $src_table
             where (type, owner) in (select (type, owner) from $success_owners)
             group by type;

$banned_ow_by_type = select type || "_banned" as type, count(owner) as cnt from $src_table
                      where (type, owner) in (select (type, owner) from $banned_owners)
                      group by type;

$failed_ow_by_type = select type || "_failed" as type, count(owner) as cnt from $src_table
                      where (type, owner) in (select (type, owner) from $failed_all__failed_feed_by_owner)
                      group by type;

$deleted_ow_by_type = select type || "_deleted" as type, count(owner) as cnt from $src_table
                      where (type, owner) not in (select (type, owner) from $owners)
                      group by type;
$union = select * from $success_ow_by_type
    union all select * from $banned_ow_by_type
    union all select * from $failed_ow_by_type
    union all select * from $deleted_ow_by_type;

$res =
SELECT * FROM (
                  SELECT
                      MULTI_AGGREGATE_BY(cnt, AggregationFactory("sum"))
                  FROM (
                           SELECT * FROM (
                                             SELECT $pivot4(TableRow()) FROM $union
                                         ) FLATTEN COLUMNS
                       )
              ) FLATTEN COLUMNS;

insert into `//home/webmaster/prod/analytics/feeds/history_changes_owners_status_raw`
select $curDate as ts, $dt as date_time, a.* from $res as a;

EVALUATE IF DateTime::ToSeconds($curDate) - $ttl > cast($dt as Int64)
DO BEGIN
    insert into `//home/webmaster/prod/analytics/feeds/added_owners_history`
    select a.*, cast($dt as Uint32) as date_time from $src_table as a;
    drop table $src_table;
end do;

end define;

evaluate for $dt in $src_dt do
begin
    DO $process_table($dt)
end do;

insert into $added_owners_path with truncate
SELECT owner, type
FROM $owners
where (owner, type) not in (select (owner, type) from $owners_old);

-- change old table
insert into `//home/webmaster/prod/analytics/feeds/old_offer_feeds` with truncate
    select * FROM $new_offer_feeds;