use arnold;
--pragma yt.QueryCacheMode="disable";

$src_root           = "//logs/deploy-logs/1d";
$dst_root_worker    = "//home/webmaster/prod/analytics/logs/deploy/backend/webmaster3-worker";
$dst_root_viewer    = "//home/webmaster/prod/analytics/logs/deploy/backend/webmaster3-viewer";
$dst_root_admin     = "//home/webmaster/prod/analytics/logs/deploy/backend/webmaster3-admin";
$PERIOD = 14;

$src_days = (
    select aggregate_list(Period)
    from (
        select TableName(Path, "yt") as Period
        from folder($src_root)
        where Type == "table"
        order by Period desc
        limit $PERIOD
    )
);

$dst_days = (
    select aggregate_list(Period)
    from (
        select TableName(Path, "yt") as Period
        from folder($dst_root_worker)
        where Type == "table"
        order by Period desc
        limit $PERIOD
    )
);

define action $copy_logs($day) as 
    $src_path = $src_root || "/" || $day;
    $dst_path_worker = $dst_root_worker || "/" || $day;
    $dst_path_viewer = $dst_root_viewer || "/" || $day;
    $dst_path_admin  = $dst_root_admin || "/" || $day;

    $logs = (
        select
            `thread_name`,
            `seq`,
            `node_fqdn`,
            `_rest`,
            `pod`,
            `message`,
            `version`,
            `_stbx`,
            `_logfeller_index_bucket`,
            `stack_trace`,
            `timestamp_nanos`,
            `timestamp`,
            `source_uri`,
            `container_id`,
            `pod_transient_fqdn`,
            `pod_persistent_fqdn`,
            `logger_name`,
            `log_level`,
            `log_level_int`,
            `stage`,
            `box`,
            `workload`,
            `iso_eventtime`,
            `host`,
            `project`,
            `context`,
            `request_id`,
            `_logfeller_timestamp`,
            `deploy_unit`
        from $src_path
        where project == "webmaster"
            and deploy_unit like "%Production%"
    );
    
    insert into $dst_path_worker
        with truncate
    select *
    from $logs
    where stage == "webmaster3-worker"
    order by
        project,
        stage,
        deploy_unit,
        iso_eventtime
    ;

    insert into $dst_path_viewer
        with truncate
    select *
    from $logs
    where stage == "webmaster3-viewer"
    order by
        project,
        stage,
        deploy_unit,
        iso_eventtime
    ;

    insert into $dst_path_admin
        with truncate
    select *
    from $logs
    where stage == "webmaster3-admin"
    order by
        project,
        stage,
        deploy_unit,
        iso_eventtime
    ;

end define;

evaluate for $day in $src_days do
    begin
        evaluate if not ListHas($dst_days, $day) do
            $copy_logs($day)
    end do
else 
    do empty_action();
