use arnold;

$src_root           = "//logs/deploy-logs/1d";
$dst_root_front     = "//home/webmaster/prod/analytics/logs/deploy/frontend/webmaster-front-production";
$PERIOD = 35;

$src_days = (
    select aggregate_list(Period)
    from (
        select TableName(Path, "yt") as Period
        from folder($src_root)
        where Type == "table"
        order by Period desc
        limit $PERIOD
    )
);

$dst_days = (
    select aggregate_list(Period)
    from (
        select TableName(Path, "yt") as Period
        from folder($dst_root_front)
        where Type == "table"
        order by Period desc
        limit $PERIOD
    )
);

define action $copy_logs($day) as 
    $src_path = $src_root || "/" || $day;
    $dst_path_front = $dst_root_front || "/" || $day;

    $logs = (
        select
            `thread_name`,
            `seq`,
            `node_fqdn`,
            `_rest`,
            `pod`,
            `message`,
            `user_id`,
            `version`,
            `_stbx`,
            `_logfeller_index_bucket`,
            `stack_trace`,
            `timestamp_nanos`,
            `timestamp`,
            `source_uri`,
            `container_id`,
            `pod_transient_fqdn`,
            `pod_persistent_fqdn`,
            `logger_name`,
            `log_level`,
            `log_level_int`,
            `stage`,
            `box`,
            `workload`,
            `iso_eventtime`,
            `host`,
            `project`,
            `context`,
            `request_id`,
            `_logfeller_timestamp`,
            `deploy_unit`
        from $src_path
        where project == "webmaster-front"
    );
    
    insert into $dst_path_front
        with truncate
    select *
    from $logs
    where stage == "webmaster_front_production"
    order by
        project,
        stage,
        deploy_unit,
        iso_eventtime
    ;
end define;

evaluate for $day in $src_days do
    begin
        evaluate if not ListHas($dst_days, $day) do
            $copy_logs($day)
    end do
else 
    do empty_action();
