use hahn;

$checkout_emails = (
    select TurboDomain, CheckoutEmail
    from (
        select
            TurboDomain,
            Yson::ConvertToString(
                ListFilter(
                    Yson::ConvertToList(TurboEcommerce.order.handlers), ($handler) -> {
                        return Yson::ConvertToString($handler.type) == "email";
                    }
                )[0].value
            ) as CheckoutEmail
        from `//home/webmaster/prod/analytics/mailings/turbo-settings`
    ) where CheckoutEmail is not null
);

select 
    TurboDomain,
    Cart,
    OrderNo,
    Email,
    CheckoutEmail
from (
    select 
        dco.TurboDomain as TurboDomain,
        dco.Cart as Cart,
        dco.OrderNo as OrderNo,
        b.Email as Email,
        ce.CheckoutEmail as CheckoutEmail
    from `//home/webmaster/users/lester/WMC-10108/domains-carts-offers` as dco
    inner join `//home/webmaster/prod/analytics/mailings/base` as b
        on dco.TurboDomain == b.TurboDomain
    inner join $checkout_emails as ce
        on dco.TurboDomain == ce.TurboDomain
    where not b.IsEuropeanUser
        and b.LanguageRU
)
group by
    TurboDomain,
    Cart,
    OrderNo,
    Email,
    CheckoutEmail
order by 
    TurboDomain,
    Email
