use hahn;
pragma yt.AutoMerge="disabled";

$TurboAutoAdvertisingTypes = (
    "top",
    "auto",
    "auto_cards"
);

$IsAutoAdvertising = ($record) -> {
    return Yson::ConvertToString($record.placed) in $TurboAutoAdvertisingTypes;
};

$IsTurboAutoAdvertisingEnabled = ($records) -> {
    return ListLength(
        ListFilter(
            Yson::ConvertToList($records),
            $IsAutoAdvertising
        )
    ) > 0
};

$IsTurboManualAdvertisingEnabled = ($records) -> {
    return ListLength(
        ListFilter(
            Yson::ConvertToList($records),
            ($x) -> {
                return not $IsAutoAdvertising($x);
            }
        )
    ) > 0
};

select 
    Email,
    Domain,
    "https://webmaster.yandex.ru/site/" || some(HostId) || "/turbo/settings/advertising/" as LinkTurboAdv
from `//home/webmaster/prod/analytics/mailings/base`
where IsTurboContent
    and not IsEuropeanUser
    and LanguageRU
    and GLOBAL_NOTIFICATION
    and MainMirror == HostUrl
    and $IsTurboManualAdvertisingEnabled(TurboAdvertising)
group by
    Email,
    Domain
order by
    Email,
    Domain
