use hahn;

/*
Нужно к ним приматчить имейлы и отфильтровать (убрать):

хосты, у кого есть загруженные фиды в Товарной вертикали
европейцев
В выгрузке нужны поля:

host
email
похостовая ссылка на https://webmaster.yandex.ru/site/serp-snippets/admin-feeds/
подписан на рекламы (да/нет)
*/

$domains_to_remove = (
    select distinct Domain
    from `//home/webmaster/prod/analytics/feeds/feeds-statuses-info`
    where Type == 'STORES'
);

select distinct
    Domain,
    Email,
    from_e_katalog,
    from_shopping,
    has_feed_in_wm,
    if (GLOBAL_NOTIFICATION, "Да", "Нет") as GLOBAL_NOTIFICATION,
    "https://webmaster.yandex.ru/site/" || HostId || "/serp-snippets/admin-feeds/" as Link
from `//home/goods-analytics/olliva/hosts_from_gsh_and_ekatalog` as src
inner join `//home/webmaster/prod/analytics/mailings/base` as base
    on src.domain == base.TurboDomain
where domain not in $domains_to_remove
    and not base.IsEuropeanUser
    and MainMirror == HostUrl
