use arnold;

$IsCrawlEnabled = ($crawl_counters) -> {
    return not Yson::IsEntity($crawl_counters)
        and ListLength(Yson::ConvertToList($crawl_counters)) > 0
};

$lost_hits = (
    select 
        Host,
        PossibleExtraShows, 
        ListSortDesc(
            ListFilter(
                TopUrlsWithShows,
                ($sample) -> {
                    return $sample.TimeUntilDeployingInHrs >= 1.0
                }
            ),
            ($sample) -> {
                return $sample.TimeUntilDeployingInHrs;
            }
        ) as TopUrlsWithShows,
        ListAvg(
            ListMap(TopUrlsWithShows, ($sample) -> {
                    return $sample.TimeUntilDeployingInHrs;
            })
        ) as AvgTimeUntilDeployingInHrs
    from `//home/robot-quality/losthits-stat/losthits-hosts-week.2020-10-21` as l
);

$domain_pairs = (
    select Domain, DomainPair
    from `//home/webmaster/users/lester/WMC-9946/traffic-seq`
    group by     
        Url::PunycodeToHostName(Url::CutWWW(Url::CutScheme(Host))) as Domain,
        Url::PunycodeToHostName(Url::CutWWW(Url::CutScheme(HostPair))) as DomainPair
);

$group1 = (
    select 
        Domain,
        Email,
        some(PossibleExtraShows) as PossibleExtraShows,
        some(Example1_Url) as Example1_Url,
        some(Example1_Hours) as Example1_Hours,
        some(AvgTimeUntilDeployingInHrs) as AvgTimeUntilDeployingInHrs,
    from (
        select 
            Host,
            Domain,
            Email,
            PossibleExtraShows, 
            TopUrlsWithShows[0].Url as Example1_Url,
            TopUrlsWithShows[0].TimeUntilDeployingInHrs as Example1_Hours,
            AvgTimeUntilDeployingInHrs,
        from $lost_hits as l
        inner join `//home/webmaster/prod/analytics/mailings/base` as m
            on l.Host == m.HostUrl
        where ListLength(TopUrlsWithShows) > 0
            and LanguageRU
            and not IsEuropeanUser
            and PossibleExtraShows >= 5
            and not $IsCrawlEnabled(MetrikaParams.CrawlCounters)
    ) as m
    group by
        Domain,
        Email
);

select * 
from $group1
order by
    Email,
    Domain
into result Group1;

$group2 = (
    select 
        Email,
        Domain,
    from $domain_pairs as dp
    inner join $group1 as g1
        on dp.Domain == g1.Domain
    inner join `//home/webmaster/prod/analytics/mailings/base` as m
        on m.Domain == dp.DomainPair
    where LanguageRU
        and not IsEuropeanUser
        and not $IsCrawlEnabled(MetrikaParams.CrawlCounters)
    group by 
        m.Email as Email,
        DomainPair as Domain
);

select *
from $group2
order by
    Email,
    Domain
into result Group2;

select g1.Domain
from $group1 as g1
inner join $group2 as g2
    on g1.Domain == g2.Domain
into result Validate;
