use hahn;

$shops_clf = (
    select distinct Analogy as TurboDomain
    from `//home/webmaster/users/lester/WMC-9923/shop_domains_host2vec`
);

$shops_market = (
    select TurboDomain
    from `//home/webmaster/users/lester/WMC-9994/market-domains`
);

$shops_wm_not_turbo = (
    select TurboDomain
    from `//home/webmaster/prod/analytics/mailings/base`
    where not IsTurboShop
        and TurboDomain in $shops_market
);

$shops_wm_turbo = (
    select TurboDomain
    from `//home/webmaster/prod/analytics/mailings/base`
    where IsTurboShop
);

$emails_exclude = (
    select Email
    from `//home/webmaster/users/lester/WMC-9994/minus-emails`
);

select Email, Domain
from `//home/webmaster/prod/analytics/mailings/base`
where String::ToLower(Email) not in $emails_exclude
    and TurboDomain in $shops_wm_not_turbo
    and LanguageRU
    and not IsEuropeanUser
group by Email, Domain
into result ShopsWmNotTurbo;

select Email, Domain
from `//home/webmaster/prod/analytics/mailings/base`
where String::ToLower(Email) not in $emails_exclude
    and TurboDomain in $shops_wm_turbo
    and LanguageRU
    and not IsEuropeanUser
group by Email, Domain
into result ShopsWmTurbo;
